/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.AnnotationConfigurable;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class QuarkusControllerConfiguration<R extends HasMetadata>
implements ControllerConfiguration<R> {
    private static final ResourceEventFilter DEFAULT = new PassthroughResourceEventFilter();
    private final String associatedReconcilerClassName;
    private final String name;
    private final String resourceTypeName;
    private final String crVersion;
    private final boolean generationAware;
    private final boolean statusPresentAndNotVoid;
    private final List<DependentResourceSpec> dependentResources;
    private final Class<R> resourceClass;
    private final ResourceEventFilter<R> eventFilter;
    private final Optional<Duration> maxReconciliationInterval;
    private final Optional<OnAddFilter<R>> onAddFilter;
    private final Optional<OnUpdateFilter<R>> onUpdateFilter;
    private final Optional<GenericFilter<R>> genericFilter;
    private Retry retry;
    private final Class<? extends Annotation> retryConfigurationClass;
    private final RateLimiter rateLimiter;
    private final Class<? extends Annotation> rateLimiterConfigurationClass;
    private String finalizer;
    private Set<String> namespaces;
    private RetryConfiguration retryConfiguration;
    private String labelSelector;
    @IgnoreProperty
    private boolean namespaceExpansionRequired;

    @RecordableConstructor
    public QuarkusControllerConfiguration(String associatedReconcilerClassName, String name, String resourceTypeName, String crVersion, boolean generationAware, Class<R> resourceClass, Set<String> namespaces, String finalizerName, String labelSelector, boolean statusPresentAndNotVoid, List<DependentResourceSpec> dependentResources, ResourceEventFilter<R> eventFilter, Duration maxReconciliationInterval, OnAddFilter<R> onAddFilter, OnUpdateFilter<R> onUpdateFilter, GenericFilter<R> genericFilter, Retry retry, Class<? extends Annotation> retryConfigurationClass, RateLimiter rateLimiter, Class<? extends Annotation> rateLimiterConfigurationClass) {
        this.associatedReconcilerClassName = associatedReconcilerClassName;
        this.name = name;
        this.resourceTypeName = resourceTypeName;
        this.crVersion = crVersion;
        this.generationAware = generationAware;
        this.resourceClass = resourceClass;
        this.retryConfiguration = super.getRetryConfiguration();
        this.setNamespaces(namespaces);
        this.setFinalizer(finalizerName);
        this.labelSelector = labelSelector;
        this.statusPresentAndNotVoid = statusPresentAndNotVoid;
        this.dependentResources = dependentResources;
        this.eventFilter = eventFilter != null ? eventFilter : DEFAULT;
        this.maxReconciliationInterval = maxReconciliationInterval != null ? Optional.of(maxReconciliationInterval) : super.maxReconciliationInterval();
        this.onAddFilter = Optional.ofNullable(onAddFilter);
        this.onUpdateFilter = Optional.ofNullable(onUpdateFilter);
        this.genericFilter = Optional.ofNullable(genericFilter);
        this.retry = retry;
        this.retryConfigurationClass = retryConfigurationClass;
        this.rateLimiter = rateLimiter != null ? rateLimiter : new DefaultRateLimiter();
        this.rateLimiterConfigurationClass = rateLimiterConfigurationClass;
    }

    public Class<R> getResourceClass() {
        return this.resourceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public String getCrVersion() {
        return this.crVersion;
    }

    public String getFinalizerName() {
        return this.finalizer;
    }

    public void setFinalizer(String finalizer) {
        this.finalizer = finalizer != null && !finalizer.isBlank() ? finalizer : ReconcilerUtils.getDefaultFinalizerName((String)this.resourceTypeName);
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedReconcilerClassName() {
        return this.associatedReconcilerClassName;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    void setNamespaces(Collection<String> namespaces) {
        if (namespaces != null && !namespaces.isEmpty()) {
            this.namespaces = Set.copyOf(namespaces);
            this.namespaceExpansionRequired = namespaces.stream().anyMatch(ns -> ns.contains("${"));
        } else {
            this.namespaces = Constants.DEFAULT_NAMESPACES_SET;
            this.namespaceExpansionRequired = false;
        }
    }

    public boolean isNamespaceExpansionRequired() {
        return this.namespaceExpansionRequired;
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    void setRetryConfiguration(RetryConfiguration retryConfiguration) {
        RetryConfiguration retryConfiguration2 = this.retryConfiguration = retryConfiguration != null ? retryConfiguration : super.getRetryConfiguration();
        if (this.retry == null || this.retry instanceof GenericRetry) {
            this.retry = GenericRetry.fromConfiguration((RetryConfiguration)retryConfiguration);
        }
    }

    @IgnoreProperty
    public Set<String> getEffectiveNamespaces() {
        return super.getEffectiveNamespaces();
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
    }

    public boolean isStatusPresentAndNotVoid() {
        return this.statusPresentAndNotVoid;
    }

    public List<DependentResourceSpec> getDependentResources() {
        return this.dependentResources;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public ResourceEventFilter<R> getEventFilter() {
        return this.eventFilter;
    }

    public Optional<Duration> maxReconciliationInterval() {
        return this.maxReconciliationInterval;
    }

    public Duration getMaxReconciliationInterval() {
        return this.maxReconciliationInterval.orElseThrow();
    }

    public OnAddFilter<R> getOnAddFilter() {
        return this.onAddFilter.orElse(null);
    }

    public Optional<OnAddFilter<R>> onAddFilter() {
        return this.onAddFilter;
    }

    public OnUpdateFilter<R> getOnUpdateFilter() {
        return this.onUpdateFilter.orElse(null);
    }

    public Optional<OnUpdateFilter<R>> onUpdateFilter() {
        return this.onUpdateFilter;
    }

    public GenericFilter<R> getGenericFilter() {
        return this.genericFilter.orElse(null);
    }

    public Optional<GenericFilter<R>> genericFilter() {
        return this.genericFilter;
    }

    void initAnnotationConfigurables(Reconciler<R> reconciler) {
        Class<?> reconcilerClass = reconciler.getClass();
        if (this.retryConfigurationClass != null) {
            this.configure(reconcilerClass, this.retryConfigurationClass, (AnnotationConfigurable)this.retry);
        }
        if (this.rateLimiterConfigurationClass != null) {
            this.configure(reconcilerClass, this.rateLimiterConfigurationClass, (AnnotationConfigurable)this.rateLimiter);
        }
    }

    public Class<? extends Annotation> getRetryConfigurationClass() {
        return this.retryConfigurationClass;
    }

    public Class<? extends Annotation> getRateLimiterConfigurationClass() {
        return this.rateLimiterConfigurationClass;
    }

    private void configure(Class<? extends Reconciler> reconcilerClass, Class<? extends Annotation> configurationClass, AnnotationConfigurable configurable) {
        Annotation annotation;
        if (configurationClass != null && (annotation = reconcilerClass.getAnnotation(configurationClass)) != null) {
            configurable.initFrom(annotation);
        }
    }

    public static final class DefaultRateLimiter
    extends LinearRateLimiter {
        public DefaultRateLimiter() {
        }

        @RecordableConstructor
        public DefaultRateLimiter(Duration refreshPeriod, int limitForPeriod) {
            super(refreshPeriod, limitForPeriod);
        }
    }

    public static final class PassthroughResourceEventFilter
    implements ResourceEventFilter {
        public boolean acceptChange(Controller controller, HasMetadata hasMetadata, HasMetadata p1) {
            return true;
        }
    }
}

