/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.model.Scope;
import io.quarkus.runtime.annotations.RecordableConstructor;

public class ResourceInfo {
    private final String group;
    private final String version;
    private final String kind;
    private final String singular;
    private final String plural;
    private final String[] shortNames;
    private final boolean storage;
    private final boolean served;
    private final Scope scope;
    private final String resourceClassName;
    private final boolean statusPresentAndNotVoid;
    private final String resourceFullName;
    private final String controllerName;

    @RecordableConstructor
    public ResourceInfo(String group, String version, String kind, String singular, String plural, String[] shortNames, boolean storage, boolean served, Scope scope, String resourceClassName, boolean statusPresentAndNotVoid, String resourceFullName, String controllerName) {
        this.group = group;
        this.version = version;
        this.kind = kind;
        this.singular = singular;
        this.plural = plural;
        this.shortNames = shortNames;
        this.storage = storage;
        this.served = served;
        this.scope = scope;
        this.resourceClassName = resourceClassName;
        this.statusPresentAndNotVoid = statusPresentAndNotVoid;
        this.resourceFullName = resourceFullName;
        this.controllerName = controllerName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public String getSingular() {
        return this.singular;
    }

    public String getPlural() {
        return this.plural;
    }

    public String[] getShortNames() {
        return this.shortNames;
    }

    public boolean isStorage() {
        return this.storage;
    }

    public boolean isServed() {
        return this.served;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public boolean isStatusPresentAndNotVoid() {
        return this.statusPresentAndNotVoid;
    }

    public String getResourceFullName() {
        return this.resourceFullName;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceInfo that = (ResourceInfo)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        return this.kind.equals(that.kind);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.kind.hashCode();
        return result;
    }

    public static ResourceInfo createFrom(Class<? extends HasMetadata> resourceClass, String resourceFullName, String associatedControllerName, boolean hasStatus) {
        Scope scope = Namespaced.class.isAssignableFrom(resourceClass) ? Scope.NAMESPACED : Scope.CLUSTER;
        return new ResourceInfo(HasMetadata.getGroup(resourceClass), HasMetadata.getVersion(resourceClass), HasMetadata.getKind(resourceClass), HasMetadata.getSingular(resourceClass), HasMetadata.getPlural(resourceClass), new String[0], false, false, scope, resourceClass.getCanonicalName(), hasStatus, resourceFullName, associatedControllerName);
    }
}

