/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime.devconsole;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.event.EventSourceMetadata;
import io.javaoperatorsdk.operator.processing.event.source.Configurable;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventSource;
import io.quarkiverse.operatorsdk.runtime.devconsole.EventSourceInfo;
import io.quarkus.arc.Arc;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;

public class DependentInfo<R, P extends HasMetadata> {
    private final DependentResourceSpec<R, P> spec;
    private final EventSourceContext<P> context;

    public DependentInfo(DependentResourceSpec<R, P> spec, EventSourceContext<P> context) {
        this.spec = spec;
        this.context = context;
    }

    EventSource eventSource() {
        DependentResource dependent = (DependentResource)Arc.container().instance(this.spec.getDependentResourceClass(), new Annotation[0]).get();
        return dependent.eventSource(this.context).orElse(null);
    }

    public EventSourceInfo getEventSource() {
        return Optional.ofNullable(this.eventSource()).map(es -> new EventSourceMetadata((EventSource)es){
            final /* synthetic */ EventSource val$es;
            {
                this.val$es = eventSource;
            }

            public String name() {
                return DependentInfo.this.getName();
            }

            public Class<?> type() {
                return this.val$es.getClass();
            }

            public Optional<Class<?>> resourceType() {
                return this.val$es instanceof ResourceEventSource ? Optional.of(((ResourceEventSource)this.val$es).resourceType()) : Optional.empty();
            }

            public Optional<?> configuration() {
                return this.val$es instanceof Configurable ? Optional.of(((Configurable)this.val$es).configuration()) : Optional.empty();
            }
        }).map(EventSourceInfo::new).orElse(null);
    }

    public String getResourceClass() {
        DependentResource dependent = (DependentResource)Arc.container().instance(this.spec.getDependentResourceClass(), new Annotation[0]).get();
        return dependent.resourceType().getName();
    }

    public Optional<?> getDependentResourceConfiguration() {
        return null;
    }

    public String getName() {
        return this.spec.getName();
    }

    public Set<String> getDependsOn() {
        return this.spec.getDependsOn();
    }

    public Condition getReadyCondition() {
        return this.spec.getReadyCondition();
    }

    public Condition getReconcileCondition() {
        return this.spec.getReconcileCondition();
    }

    public Condition getDeletePostCondition() {
        return this.spec.getDeletePostCondition();
    }

    public Optional<String> getUseEventSourceWithName() {
        return this.spec.getUseEventSourceWithName();
    }

    public String getType() {
        return this.spec.getDependentResourceClass().getName();
    }
}

