/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime.devconsole;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.event.source.IndexerResourceCache;
import io.quarkiverse.operatorsdk.runtime.devconsole.DependentInfo;
import io.quarkiverse.operatorsdk.runtime.devconsole.EventSourceInfo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ControllerInfo<P extends HasMetadata> {
    private final Controller<P> controller;
    private final Set<EventSourceInfo> eventSources;
    private final Set<DependentInfo> dependents;

    public ControllerInfo(Controller<P> controller) {
        this.controller = controller;
        EventSourceContext context = new EventSourceContext((IndexerResourceCache)controller.getEventSourceManager().getControllerResourceEventSource(), controller.getConfiguration(), controller.getClient());
        this.dependents = controller.getConfiguration().getDependentResources().stream().map(spec -> new DependentInfo(spec, context)).collect(Collectors.toSet());
        this.eventSources = controller.getEventSourceManager().getNamedEventSourcesStream().map(EventSourceInfo::new).collect(Collectors.toSet());
    }

    public String getName() {
        return this.controller.getConfiguration().getName();
    }

    public Class<P> getResourceClass() {
        return this.controller.getConfiguration().getResourceClass();
    }

    public Set<String> getEffectiveNamespaces() {
        return this.controller.getConfiguration().getEffectiveNamespaces();
    }

    public Set<EventSourceInfo> getEventSources() {
        return this.eventSources;
    }

    public Set<DependentInfo> getDependents() {
        return this.dependents;
    }

    public List<P> getKnownResources() {
        return this.controller.getEventSourceManager().getControllerResourceEventSource().list().collect(Collectors.toList());
    }
}

