/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.KubernetesClientSerializationCustomizer;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RetryConfigurationResolver;
import io.quarkiverse.operatorsdk.runtime.RunTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ProfileManager;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class ConfigurationServiceRecorder {
    static final Logger log = Logger.getLogger((String)ConfigurationServiceRecorder.class.getName());

    public Supplier<QuarkusConfigurationService> configurationServiceSupplier(Version version, Map<String, QuarkusControllerConfiguration> configurations, CRDGenerationInfo crdInfo, RunTimeOperatorConfiguration runTimeConfiguration, BuildTimeOperatorConfiguration buildTimeConfiguration, LaunchMode launchMode) {
        Integer maxThreads = runTimeConfiguration.concurrentReconciliationThreads.orElse(200);
        Integer timeout = runTimeConfiguration.terminationTimeoutSeconds.orElse(10);
        Integer workflowThreads = runTimeConfiguration.concurrentWorkflowThreads.orElse(200);
        Duration cacheSyncTimeout = runTimeConfiguration.cacheSyncTimeout;
        configurations.forEach((name, c) -> {
            Retry retry;
            RunTimeControllerConfiguration extConfig = runTimeConfiguration.controllers.get(name);
            if (extConfig != null) {
                extConfig.finalizer.ifPresent(c::setFinalizer);
                extConfig.selector.ifPresent(c::setLabelSelector);
                extConfig.namespaces.map(HashSet::new).ifPresent(c::setNamespaces);
                c.setRetryConfiguration(RetryConfigurationResolver.resolve(extConfig.retry));
            }
            if ((retry = c.getRetry()) == null) {
                c.setRetryConfiguration(null);
            }
            if (!c.isWereNamespacesSet()) {
                runTimeConfiguration.namespaces.ifPresent(ns -> c.setNamespaces(new HashSet<String>((Collection<String>)ns)));
            }
        });
        return () -> {
            ObjectMapper mapper = Serialization.jsonMapper();
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            ArcContainer container = Arc.container();
            container.select(ObjectMapperCustomizer.class, new Annotation[]{KubernetesClientSerializationCustomizer.Literal.INSTANCE}).stream().sorted().forEach(c -> c.customize(mapper));
            LeaderElectionConfiguration leaderElectionConfiguration = null;
            String profile = ProfileManager.getActiveProfile();
            if (buildTimeConfiguration.activateLeaderElectionForProfiles.contains(profile)) {
                leaderElectionConfiguration = (LeaderElectionConfiguration)container.instance(LeaderElectionConfiguration.class, new Annotation[0]).get();
            } else {
                log.info((Object)("Leader election deactivated for " + profile + " profile"));
            }
            return new QuarkusConfigurationService(version, configurations.values(), (KubernetesClient)container.instance(KubernetesClient.class, new Annotation[0]).get(), crdInfo, maxThreads, workflowThreads, timeout, cacheSyncTimeout, (Metrics)container.instance(Metrics.class, new Annotation[0]).get(), ConfigurationServiceRecorder.shouldStartOperator(buildTimeConfiguration.startOperator, launchMode), mapper, leaderElectionConfiguration, (InformerStoppedHandler)container.instance(InformerStoppedHandler.class, new Annotation[0]).orElse(null), buildTimeConfiguration.closeClientOnStop, buildTimeConfiguration.stopOnInformerErrorDuringStartup);
        };
    }

    static boolean shouldStartOperator(Optional<Boolean> fromConfiguration, LaunchMode launchMode) {
        if (fromConfiguration == null || fromConfiguration.isEmpty()) {
            return LaunchMode.TEST != launchMode;
        }
        return fromConfiguration.orElse(true);
    }
}

