/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.RuntimeInfo;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class OperatorHealthCheck
implements HealthCheck {
    public static final String HEALTH_CHECK_NAME = "Quarkus Operator SDK health check";
    public static final String OK = "OK";
    @Inject
    Operator operator;

    public HealthCheckResponse call() {
        RuntimeInfo runtimeInfo = this.operator.getRuntimeInfo();
        if (runtimeInfo.isStarted()) {
            HealthCheckResponseBuilder response = HealthCheckResponse.named((String)HEALTH_CHECK_NAME);
            boolean[] healthy = new boolean[]{true};
            runtimeInfo.getRegisteredControllers().forEach(rc -> {
                String name = rc.getConfiguration().getName();
                Map unhealthy = rc.getControllerHealthInfo().unhealthyEventSources();
                if (unhealthy.isEmpty()) {
                    response.withData(name, OK);
                } else {
                    healthy[0] = false;
                    response.withData(name, "unhealthy: " + String.join((CharSequence)", ", unhealthy.keySet()));
                }
            });
            if (healthy[0]) {
                response.up();
            } else {
                response.down();
            }
            return response.build();
        }
        return HealthCheckResponse.down((String)HEALTH_CHECK_NAME);
    }
}

