/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.AnnotationConfigurable;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationProvider;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.processing.Controller;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusKubernetesDependentResourceConfig;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class QuarkusControllerConfiguration<R extends HasMetadata>
implements ControllerConfiguration<R>,
DependentResourceConfigurationProvider {
    private static final ResourceEventFilter DEFAULT = new PassthroughResourceEventFilter();
    private final String associatedReconcilerClassName;
    private final String name;
    private final String resourceTypeName;
    private final String crVersion;
    private final boolean generationAware;
    private final boolean statusPresentAndNotVoid;
    private final Class<R> resourceClass;
    private final Optional<Long> informerListLimit;
    private final ResourceEventFilter<R> eventFilter;
    private final Optional<Duration> maxReconciliationInterval;
    private final Optional<OnAddFilter<? super R>> onAddFilter;
    private final Optional<OnUpdateFilter<? super R>> onUpdateFilter;
    private final Optional<GenericFilter<? super R>> genericFilter;
    private final List<PolicyRule> additionalRBACRules;
    private Class<? extends Annotation> retryConfigurationClass;
    private Class<? extends Retry> retryClass;
    private Class<? extends Annotation> rateLimiterConfigurationClass;
    private Class<? extends RateLimiter> rateLimiterClass;
    private String finalizer;
    private Set<String> namespaces;
    private boolean wereNamespacesSet;
    private RetryConfiguration retryConfiguration;
    private String labelSelector;
    private final Map<String, DependentResourceSpecMetadata<?, ?, ?>> dependentsMetadata;
    private Retry retry;
    private RateLimiter rateLimiter;
    private ManagedWorkflow<R> workflow;
    private QuarkusConfigurationService parent;

    @RecordableConstructor
    public QuarkusControllerConfiguration(String associatedReconcilerClassName, String name, String resourceTypeName, String crVersion, boolean generationAware, Class resourceClass, Long nullableInformerListLimit, Set<String> namespaces, boolean wereNamespacesSet, String finalizerName, String labelSelector, boolean statusPresentAndNotVoid, ResourceEventFilter eventFilter, Duration maxReconciliationInterval, OnAddFilter<R> onAddFilter, OnUpdateFilter<R> onUpdateFilter, GenericFilter<R> genericFilter, Class<? extends Retry> retryClass, Class<? extends Annotation> retryConfigurationClass, Class<? extends RateLimiter> rateLimiterClass, Class<? extends Annotation> rateLimiterConfigurationClass, Map<String, DependentResourceSpecMetadata<?, ?, ?>> dependentsMetadata, ManagedWorkflow<R> workflow, List<PolicyRule> additionalRBACRules) {
        this.associatedReconcilerClassName = associatedReconcilerClassName;
        this.name = name;
        this.resourceTypeName = resourceTypeName;
        this.crVersion = crVersion;
        this.generationAware = generationAware;
        this.resourceClass = resourceClass;
        this.informerListLimit = Optional.ofNullable(nullableInformerListLimit);
        this.additionalRBACRules = additionalRBACRules;
        this.dependentsMetadata = dependentsMetadata;
        this.workflow = workflow;
        this.retryConfiguration = super.getRetryConfiguration();
        this.setNamespaces(namespaces);
        this.wereNamespacesSet = wereNamespacesSet;
        this.setFinalizer(finalizerName);
        this.labelSelector = labelSelector;
        this.statusPresentAndNotVoid = statusPresentAndNotVoid;
        this.eventFilter = eventFilter != null ? eventFilter : DEFAULT;
        this.maxReconciliationInterval = maxReconciliationInterval != null ? Optional.of(maxReconciliationInterval) : super.maxReconciliationInterval();
        this.onAddFilter = Optional.ofNullable(onAddFilter);
        this.onUpdateFilter = Optional.ofNullable(onUpdateFilter);
        this.genericFilter = Optional.ofNullable(genericFilter);
        this.retryClass = retryClass;
        this.retry = GenericRetry.class.equals(retryClass) ? super.getRetry() : null;
        this.retryConfigurationClass = retryConfigurationClass;
        this.rateLimiterClass = rateLimiterClass;
        this.rateLimiter = DefaultRateLimiter.class.equals(rateLimiterClass) ? new DefaultRateLimiter() : null;
        this.rateLimiterConfigurationClass = rateLimiterConfigurationClass;
    }

    @IgnoreProperty
    public ConfigurationService getConfigurationService() {
        return this.parent;
    }

    public void setParent(QuarkusConfigurationService parent) {
        this.parent = parent;
    }

    public Class<R> getResourceClass() {
        return this.resourceClass;
    }

    public Optional<Long> getInformerListLimit() {
        return this.informerListLimit;
    }

    public Long getNullableInformerListLimit() {
        return this.informerListLimit.orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public String getCrVersion() {
        return this.crVersion;
    }

    public String getFinalizerName() {
        return this.finalizer;
    }

    public void setFinalizer(String finalizer) {
        this.finalizer = finalizer != null && !finalizer.isBlank() ? finalizer : ReconcilerUtils.getDefaultFinalizerName((String)this.resourceTypeName);
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedReconcilerClassName() {
        return this.associatedReconcilerClassName;
    }

    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    void setNamespaces(Collection<String> namespaces) {
        if (!namespaces.equals(this.namespaces)) {
            this.namespaces = namespaces.stream().map(String::trim).collect(Collectors.toSet());
            this.wereNamespacesSet = true;
            this.dependentsMetadata.forEach((name, spec) -> {
                Object config = spec.getDependentResourceConfig();
                if (config instanceof QuarkusKubernetesDependentResourceConfig) {
                    QuarkusKubernetesDependentResourceConfig qConfig = (QuarkusKubernetesDependentResourceConfig)((Object)((Object)config));
                    qConfig.setNamespaces(this.namespaces);
                }
            });
        }
    }

    public boolean isWereNamespacesSet() {
        return this.wereNamespacesSet;
    }

    public RetryConfiguration getRetryConfiguration() {
        return this.retryConfiguration;
    }

    void setRetryConfiguration(RetryConfiguration retryConfiguration) {
        RetryConfiguration retryConfiguration2 = this.retryConfiguration = retryConfiguration != null ? retryConfiguration : super.getRetryConfiguration();
        if (this.retry == null || this.retry instanceof GenericRetry) {
            this.retry = GenericRetry.fromConfiguration((RetryConfiguration)retryConfiguration);
        }
    }

    @IgnoreProperty
    public Set<String> getEffectiveNamespaces() {
        return super.getEffectiveNamespaces();
    }

    public String getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
    }

    public boolean isStatusPresentAndNotVoid() {
        return this.statusPresentAndNotVoid;
    }

    public boolean areDependentsImpactedBy(Set<String> changedClasses) {
        return this.dependentsMetadata.keySet().parallelStream().anyMatch(changedClasses::contains);
    }

    public boolean needsDependentBeansCreation() {
        return this.dependentsMetadata != null && !this.dependentsMetadata.isEmpty();
    }

    public ManagedWorkflow<R> getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(ManagedWorkflow<R> workflow) {
        this.workflow = workflow;
    }

    public Object getConfigurationFor(DependentResourceSpec dependentResourceSpec) {
        return ((DependentResourceSpecMetadata)dependentResourceSpec).getDependentResourceConfig();
    }

    public List<DependentResourceSpec> getDependentResources() {
        return this.dependentsMetadata.values().parallelStream().collect(Collectors.toList());
    }

    public Retry getRetry() {
        return this.retry;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public ResourceEventFilter<R> getEventFilter() {
        return this.eventFilter;
    }

    public Optional<Duration> maxReconciliationInterval() {
        return this.maxReconciliationInterval;
    }

    public Duration getMaxReconciliationInterval() {
        return this.maxReconciliationInterval.orElseThrow();
    }

    public OnAddFilter<? super R> getOnAddFilter() {
        return this.onAddFilter.orElse(null);
    }

    public Optional<OnAddFilter<? super R>> onAddFilter() {
        return this.onAddFilter;
    }

    public OnUpdateFilter<? super R> getOnUpdateFilter() {
        return this.onUpdateFilter.orElse(null);
    }

    public Optional<OnUpdateFilter<? super R>> onUpdateFilter() {
        return this.onUpdateFilter;
    }

    public GenericFilter<? super R> getGenericFilter() {
        return this.genericFilter.orElse(null);
    }

    public Optional<GenericFilter<? super R>> genericFilter() {
        return this.genericFilter;
    }

    public Class<? extends Retry> getRetryClass() {
        return this.retryClass;
    }

    public Class<? extends RateLimiter> getRateLimiterClass() {
        return this.rateLimiterClass;
    }

    public Map<String, DependentResourceSpecMetadata<?, ?, ?>> getDependentsMetadata() {
        return this.dependentsMetadata;
    }

    void initAnnotationConfigurables(Reconciler<R> reconciler) {
        Class<?> reconcilerClass = reconciler.getClass();
        if (this.retryConfigurationClass != null) {
            if (this.retry == null) {
                this.retry = (Retry)ClassLoadingUtils.instantiate(this.retryClass);
            }
            this.configure(reconcilerClass, this.retryConfigurationClass, (AnnotationConfigurable)this.retry);
            this.retryClass = null;
            this.retryConfigurationClass = null;
        }
        if (this.rateLimiterClass != null) {
            if (this.rateLimiter == null) {
                this.rateLimiter = (RateLimiter)ClassLoadingUtils.instantiate(this.rateLimiterClass);
            }
            this.configure(reconcilerClass, this.rateLimiterConfigurationClass, (AnnotationConfigurable)this.rateLimiter);
            this.rateLimiterClass = null;
            this.rateLimiterConfigurationClass = null;
        }
    }

    public Class<? extends Annotation> getRetryConfigurationClass() {
        return this.retryConfigurationClass;
    }

    public Class<? extends Annotation> getRateLimiterConfigurationClass() {
        return this.rateLimiterConfigurationClass;
    }

    private void configure(Class<? extends Reconciler> reconcilerClass, Class<? extends Annotation> configurationClass, AnnotationConfigurable configurable) {
        Annotation annotation;
        if (configurationClass != null && (annotation = reconcilerClass.getAnnotation(configurationClass)) != null) {
            configurable.initFrom(annotation);
        }
    }

    public List<PolicyRule> getAdditionalRBACRules() {
        return this.additionalRBACRules;
    }

    public static final class DefaultRateLimiter
    extends LinearRateLimiter {
        public DefaultRateLimiter() {
        }

        @RecordableConstructor
        public DefaultRateLimiter(Duration refreshPeriod, int limitForPeriod) {
            super(refreshPeriod, limitForPeriod);
        }
    }

    public static final class PassthroughResourceEventFilter
    implements ResourceEventFilter {
        public boolean acceptChange(Controller controller, HasMetadata hasMetadata, HasMetadata p1) {
            return true;
        }
    }
}

