/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jboss.logging.Logger;

public final class CRDUtils {
    private static final Logger LOGGER = Logger.getLogger((String)CRDUtils.class.getName());

    private CRDUtils() {
    }

    public static void applyCRD(KubernetesClient client, CRDGenerationInfo crdInfo, String crdName) {
        try {
            crdInfo.getCRDInfosFor(crdName).forEach((crdVersion, info) -> {
                Path filePath = Path.of(info.getFilePath(), new String[0]);
                try {
                    Object crd = client.getKubernetesSerialization().unmarshal(Files.newInputStream(filePath, new OpenOption[0]), CRDUtils.getCRDClassFor(crdVersion));
                    CRDUtils.apply(client, crdVersion, crd);
                    LOGGER.infov("Applied {0} CRD named ''{1}'' from {2}", crdVersion, (Object)crdName, (Object)filePath);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Couldn't read CRD file at " + filePath + " as a " + crdVersion + " CRD for " + crdName, ex);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.debugv((Throwable)exception, "Couldn't apply ''{0}'' CRD", (Object)crdName);
        }
    }

    private static void apply(KubernetesClient client, String v, Object crd) {
        switch (v) {
            case "v1": {
                Resource resource = (Resource)client.apiextensions().v1().customResourceDefinitions().resource((Object)((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)crd));
                if (resource.get() != null) {
                    resource.update();
                    break;
                }
                resource.create();
                break;
            }
            case "v1beta1": {
                Resource legacyResource = (Resource)client.apiextensions().v1beta1().customResourceDefinitions().resource((Object)((CustomResourceDefinition)crd));
                if (legacyResource.get() != null) {
                    legacyResource.update();
                    break;
                }
                legacyResource.create();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CRD version: " + v);
            }
        }
    }

    private static Class<?> getCRDClassFor(String v) {
        switch (v) {
            case "v1": {
                return io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition.class;
            }
            case "v1beta1": {
                return CustomResourceDefinition.class;
            }
        }
        throw new IllegalArgumentException("Unknown CRD version: " + v);
    }
}

