/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.javaoperatorsdk.operator.api.config.RetryConfiguration;
import io.quarkiverse.operatorsdk.runtime.ExternalIntervalConfiguration;
import io.quarkiverse.operatorsdk.runtime.ExternalRetryConfiguration;
import io.quarkiverse.operatorsdk.runtime.PlainRetryConfiguration;
import java.util.Optional;

public class RetryConfigurationResolver
implements RetryConfiguration {
    private final RetryConfiguration delegate;

    private RetryConfigurationResolver(ExternalRetryConfiguration retry) {
        this.delegate = Optional.ofNullable(retry).map(ExternalRetryConfigurationAdapter::new).orElse(RetryConfiguration.DEFAULT);
    }

    public static RetryConfiguration resolve(ExternalRetryConfiguration retry) {
        RetryConfigurationResolver delegate = new RetryConfigurationResolver(retry);
        return new PlainRetryConfiguration(delegate.getMaxAttempts(), delegate.getInitialInterval(), delegate.getIntervalMultiplier(), delegate.getMaxInterval());
    }

    public int getMaxAttempts() {
        return this.delegate.getMaxAttempts();
    }

    public long getInitialInterval() {
        return this.delegate.getInitialInterval();
    }

    public double getIntervalMultiplier() {
        return this.delegate.getIntervalMultiplier();
    }

    public long getMaxInterval() {
        return this.delegate.getMaxInterval();
    }

    private static class IntervalConfigurationAdapter {
        private final long initial;
        private final double multiplier;
        private final long max;

        IntervalConfigurationAdapter(ExternalIntervalConfiguration config) {
            this.initial = config.initial();
            this.multiplier = config.multiplier();
            this.max = config.max().orElse(RetryConfiguration.DEFAULT.getMaxInterval());
        }

        IntervalConfigurationAdapter() {
            this.initial = RetryConfiguration.DEFAULT.getInitialInterval();
            this.multiplier = RetryConfiguration.DEFAULT.getIntervalMultiplier();
            this.max = RetryConfiguration.DEFAULT.getMaxInterval();
        }
    }

    private static class ExternalRetryConfigurationAdapter
    implements RetryConfiguration {
        private final int maxAttempts;
        private final IntervalConfigurationAdapter interval;

        public ExternalRetryConfigurationAdapter(ExternalRetryConfiguration config) {
            this.maxAttempts = config.maxAttempts().orElse(RetryConfiguration.DEFAULT.getMaxAttempts());
            this.interval = Optional.ofNullable(config.interval()).map(IntervalConfigurationAdapter::new).orElse(new IntervalConfigurationAdapter());
        }

        public int getMaxAttempts() {
            return this.maxAttempts;
        }

        public long getInitialInterval() {
            return this.interval.initial;
        }

        public double getIntervalMultiplier() {
            return this.interval.multiplier;
        }

        public long getMaxInterval() {
            return this.interval.max;
        }
    }
}

