/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import org.jboss.logging.Logger;

public final class CRDUtils {
    private static final Logger LOGGER = Logger.getLogger((String)CRDUtils.class.getName());
    private static final KubernetesSerialization SERIALIZATION = new KubernetesSerialization(new ObjectMapper(), false);
    public static final String DEFAULT_CRD_SPEC_VERSION = "v1";
    public static final String V1BETA1_CRD_SPEC_VERSION = "v1beta1";

    private CRDUtils() {
    }

    public static void applyCRD(KubernetesClient client, CRDGenerationInfo crdInfo, String crdName) {
        try {
            crdInfo.getCRDInfosFor(crdName).forEach((crdVersion, info) -> {
                Path filePath = Path.of(info.getFilePath(), new String[0]);
                try {
                    Object crd = CRDUtils.loadFrom(filePath, client.getKubernetesSerialization(), CRDUtils.getCRDClassFor(crdVersion));
                    CRDUtils.apply(client, crdVersion, crd);
                    LOGGER.infov("Applied {0} CRD named ''{1}'' from {2}", crdVersion, (Object)crdName, (Object)filePath);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Couldn't read CRD file at " + String.valueOf(filePath) + " as a " + crdVersion + " CRD for " + crdName, ex);
                }
            });
        }
        catch (Exception exception) {
            LOGGER.warnv((Throwable)exception, "Couldn't apply ''{0}'' CRD", (Object)crdName);
        }
    }

    private static <T> T loadFrom(Path crdPath, KubernetesSerialization serialization, Class<T> crdClass) throws IOException {
        serialization = serialization == null ? SERIALIZATION : serialization;
        return (T)serialization.unmarshal(Files.newInputStream(crdPath, new OpenOption[0]), crdClass);
    }

    public static io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition loadFrom(Path crdPath) throws IOException {
        io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition crd = CRDUtils.loadFrom(crdPath, null, io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition.class);
        String crdVersion = crd.getApiVersion().split("/")[1];
        if (!DEFAULT_CRD_SPEC_VERSION.equals(crdVersion)) {
            LOGGER.warnv("CRD at {0} was loaded as a {1} CRD but is defined as using {2} CRD spec version. While things might still work as expected, we recommend that you only use CRDs using the {1} CRD spec version.", (Object)crdPath, (Object)DEFAULT_CRD_SPEC_VERSION, (Object)crdVersion);
        }
        return crd;
    }

    public static CRDInfo loadFromAsCRDInfo(Path crdPath) {
        try {
            io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition crd = CRDUtils.loadFrom(crdPath);
            String crdName = crd.getMetadata().getName();
            return new CRDInfo(crdName, DEFAULT_CRD_SPEC_VERSION, crdPath.toFile().getAbsolutePath(), Collections.emptySet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void apply(KubernetesClient client, String v, Object crd) {
        switch (v) {
            case "v1": {
                Resource resource = (Resource)client.apiextensions().v1().customResourceDefinitions().resource((Object)((io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition)crd));
                if (resource.get() != null) {
                    resource.update();
                    break;
                }
                resource.create();
                break;
            }
            case "v1beta1": {
                Resource legacyResource = (Resource)client.apiextensions().v1beta1().customResourceDefinitions().resource((Object)((CustomResourceDefinition)crd));
                if (legacyResource.get() != null) {
                    legacyResource.update();
                    break;
                }
                legacyResource.create();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CRD version: " + v);
            }
        }
    }

    private static Class<?> getCRDClassFor(String v) {
        return switch (v) {
            case DEFAULT_CRD_SPEC_VERSION -> io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition.class;
            case V1BETA1_CRD_SPEC_VERSION -> CustomResourceDefinition.class;
            default -> throw new IllegalArgumentException("Unknown CRD version: " + v);
        };
    }
}

