/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.runtime.ExternalGradualRetryConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import java.util.Optional;
import org.jboss.logging.Logger;

public class GradualRetryResolver {
    private static final Logger log = Logger.getLogger((String)GradualRetryResolver.class.getName());

    public static Optional<ExternalGradualRetryConfiguration> gradualRetryIfConfigurationExists(QuarkusControllerConfiguration<?> c, ExternalGradualRetryConfiguration retry) {
        if (retry != null) {
            Class<Retry> retryClass = c.getRetryClass();
            if (!GenericRetry.class.equals(retryClass)) {
                log.warn((Object)("Retry configuration in application.properties is only appropriate when using the GenericRetry implementation, yet your Reconciler is configured to use " + retryClass.getName() + " as Retry implementation. Configuration from application.properties will therefore be ignored."));
                return Optional.empty();
            }
            return Optional.of(retry);
        }
        return Optional.empty();
    }
}

