/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.RoleRef;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.AnnotationConfigurable;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceConfigurationProvider;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.config.informer.InformerConfiguration;
import io.javaoperatorsdk.operator.api.config.workflow.WorkflowSpec;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.processing.event.rate.LinearRateLimiter;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.GenericRetry;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.quarkiverse.operatorsdk.common.ClassLoadingUtils;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.ExternalGradualRetryConfiguration;
import io.quarkiverse.operatorsdk.runtime.ExternalGradualRetryIntervalConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusInformerConfiguration;
import io.quarkiverse.operatorsdk.runtime.QuarkusManagedWorkflow;
import io.quarkiverse.operatorsdk.runtime.QuarkusWorkflowSpec;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class QuarkusControllerConfiguration<R extends HasMetadata>
implements ControllerConfiguration<R>,
DependentResourceConfigurationProvider {
    private final String associatedReconcilerClassName;
    private final String name;
    private final String resourceTypeName;
    private final String crVersion;
    private final boolean generationAware;
    private final boolean statusPresentAndNotVoid;
    private final Class<R> resourceClass;
    private final List<PolicyRule> additionalRBACRules;
    private final List<RoleRef> additionalRBACRoleRefs;
    private final String fieldManager;
    private Class<? extends Annotation> retryConfigurationClass;
    private Class<? extends Retry> retryClass;
    private Class<? extends Annotation> rateLimiterConfigurationClass;
    private Class<? extends RateLimiter> rateLimiterClass;
    private Optional<Duration> maxReconciliationInterval;
    private String finalizer;
    private boolean wereNamespacesSet;
    private Retry retry;
    private RateLimiter rateLimiter;
    private QuarkusManagedWorkflow<R> workflow;
    private ConfigurationService parent;
    private ExternalGradualRetryConfiguration gradualRetry;
    private QuarkusInformerConfiguration<R> informerConfig;

    @RecordableConstructor
    public QuarkusControllerConfiguration(String associatedReconcilerClassName, String name, String resourceTypeName, String crVersion, boolean generationAware, Class resourceClass, boolean wereNamespacesSet, String finalizerName, boolean statusPresentAndNotVoid, Duration maxReconciliationInterval, Class<? extends Retry> retryClass, Class<? extends Annotation> retryConfigurationClass, Class<? extends RateLimiter> rateLimiterClass, Class<? extends Annotation> rateLimiterConfigurationClass, List<PolicyRule> additionalRBACRules, List<RoleRef> additionalRBACRoleRefs, String fieldManager, QuarkusInformerConfiguration<R> informerConfig) {
        this.informerConfig = informerConfig;
        this.associatedReconcilerClassName = associatedReconcilerClassName;
        this.name = name;
        this.resourceTypeName = resourceTypeName;
        this.crVersion = crVersion;
        this.generationAware = generationAware;
        this.resourceClass = resourceClass;
        this.additionalRBACRules = additionalRBACRules;
        this.additionalRBACRoleRefs = additionalRBACRoleRefs;
        this.setNamespaces(informerConfig.getNamespaces());
        this.wereNamespacesSet = wereNamespacesSet;
        this.setFinalizer(finalizerName);
        this.statusPresentAndNotVoid = statusPresentAndNotVoid;
        this.maxReconciliationInterval = maxReconciliationInterval != null ? Optional.of(maxReconciliationInterval) : super.maxReconciliationInterval();
        this.retryClass = retryClass;
        this.retry = GenericRetry.class.equals(retryClass) ? new GenericRetry() : null;
        this.retryConfigurationClass = retryConfigurationClass;
        this.rateLimiterClass = rateLimiterClass;
        this.rateLimiter = DefaultRateLimiter.class.equals(rateLimiterClass) ? new DefaultRateLimiter() : null;
        this.rateLimiterConfigurationClass = rateLimiterConfigurationClass;
        this.fieldManager = fieldManager != null ? fieldManager : super.fieldManager();
    }

    @IgnoreProperty
    public ConfigurationService getConfigurationService() {
        return this.parent;
    }

    public void setParent(ConfigurationService parent) {
        this.parent = parent;
    }

    public Class<R> getResourceClass() {
        return this.resourceClass;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public String getCrVersion() {
        return this.crVersion;
    }

    public String getFinalizerName() {
        return this.finalizer;
    }

    public void setFinalizer(String finalizer) {
        this.finalizer = finalizer != null && !finalizer.isBlank() ? finalizer : ReconcilerUtils.getDefaultFinalizerName((String)this.resourceTypeName);
    }

    public boolean isGenerationAware() {
        return this.generationAware;
    }

    public String getAssociatedReconcilerClassName() {
        return this.associatedReconcilerClassName;
    }

    void setNamespaces(Set<String> namespaces) {
        if (!namespaces.equals(this.informerConfig.getNamespaces())) {
            this.informerConfig = new QuarkusInformerConfiguration(InformerConfiguration.builder(this.informerConfig).withNamespaces(namespaces).buildForController());
            this.wereNamespacesSet = true;
        }
    }

    public boolean isWereNamespacesSet() {
        return this.wereNamespacesSet;
    }

    @IgnoreProperty
    public Set<String> getEffectiveNamespaces() {
        return super.getEffectiveNamespaces();
    }

    void setLabelSelector(String labelSelector) {
        this.informerConfig = new QuarkusInformerConfiguration(InformerConfiguration.builder(this.informerConfig).withLabelSelector(labelSelector).buildForController());
    }

    public boolean isStatusPresentAndNotVoid() {
        return this.statusPresentAndNotVoid;
    }

    public boolean areDependentsImpactedBy(Set<String> changedClasses) {
        return this.dependentsMetadata().keySet().parallelStream().anyMatch(changedClasses::contains);
    }

    public boolean needsDependentBeansCreation() {
        Map<String, DependentResourceSpecMetadata> dependentsMetadata = this.dependentsMetadata();
        return dependentsMetadata != null && !dependentsMetadata.isEmpty();
    }

    public QuarkusManagedWorkflow<R> getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(QuarkusManagedWorkflow<R> workflow) {
        this.workflow = workflow;
    }

    public Object getConfigurationFor(DependentResourceSpec dependentResourceSpec) {
        return dependentResourceSpec.getConfiguration().orElse(null);
    }

    public Optional<WorkflowSpec> getWorkflowSpec() {
        return this.workflow.getGenericSpec();
    }

    public Retry getRetry() {
        return this.retry;
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public Optional<Duration> maxReconciliationInterval() {
        return this.maxReconciliationInterval;
    }

    public Duration getMaxReconciliationInterval() {
        return this.maxReconciliationInterval.orElseThrow();
    }

    void setMaxReconciliationInterval(Duration duration) {
        this.maxReconciliationInterval = Optional.of(duration);
    }

    public OnAddFilter<? super R> getOnAddFilter() {
        return this.getInformerConfig().getOnAddFilter();
    }

    public OnUpdateFilter<? super R> getOnUpdateFilter() {
        return this.getInformerConfig().getOnUpdateFilter();
    }

    public GenericFilter<? super R> getGenericFilter() {
        return this.getInformerConfig().getGenericFilter();
    }

    public Class<? extends Retry> getRetryClass() {
        return this.retryClass;
    }

    void setGradualRetryConfiguration(ExternalGradualRetryConfiguration gradualRetry) {
        this.gradualRetry = gradualRetry;
    }

    public Class<? extends RateLimiter> getRateLimiterClass() {
        return this.rateLimiterClass;
    }

    public Map<String, DependentResourceSpecMetadata> dependentsMetadata() {
        return this.workflow.getSpec().map(QuarkusWorkflowSpec::getDependentResourceSpecMetadata).orElse(Collections.emptyMap());
    }

    void initAnnotationConfigurables(Reconciler<R> reconciler) {
        Class<?> reconcilerClass = reconciler.getClass();
        if (this.retryConfigurationClass != null || this.gradualRetry != null) {
            if (this.retry == null) {
                this.retry = (Retry)ClassLoadingUtils.instantiate(this.retryClass);
            }
            this.configure(reconcilerClass, this.retryConfigurationClass, (AnnotationConfigurable)this.retry);
            if (this.gradualRetry != null) {
                GenericRetry genericRetry = (GenericRetry)this.retry;
                this.gradualRetry.maxAttempts().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setMaxAttempts(arg_0));
                ExternalGradualRetryIntervalConfiguration intervalConfiguration = this.gradualRetry.interval();
                intervalConfiguration.initial().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setInitialInterval(arg_0));
                intervalConfiguration.max().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setMaxInterval(arg_0));
                intervalConfiguration.multiplier().ifPresent(arg_0 -> ((GenericRetry)genericRetry).setIntervalMultiplier(arg_0));
            }
            this.retryClass = null;
            this.retryConfigurationClass = null;
        }
        if (this.rateLimiterClass != null) {
            if (this.rateLimiter == null) {
                this.rateLimiter = (RateLimiter)ClassLoadingUtils.instantiate(this.rateLimiterClass);
            }
            this.configure(reconcilerClass, this.rateLimiterConfigurationClass, (AnnotationConfigurable)this.rateLimiter);
            this.rateLimiterClass = null;
            this.rateLimiterConfigurationClass = null;
        }
    }

    public Class<? extends Annotation> getRetryConfigurationClass() {
        return this.retryConfigurationClass;
    }

    public Class<? extends Annotation> getRateLimiterConfigurationClass() {
        return this.rateLimiterConfigurationClass;
    }

    private void configure(Class<? extends Reconciler> reconcilerClass, Class<? extends Annotation> configurationClass, AnnotationConfigurable configurable) {
        Annotation annotation;
        if (configurationClass != null && (annotation = reconcilerClass.getAnnotation(configurationClass)) != null) {
            configurable.initFrom(annotation);
        }
    }

    public List<PolicyRule> getAdditionalRBACRules() {
        return this.additionalRBACRules;
    }

    public List<RoleRef> getAdditionalRBACRoleRefs() {
        return this.additionalRBACRoleRefs;
    }

    public String getFieldManager() {
        return this.fieldManager;
    }

    public String fieldManager() {
        return this.fieldManager;
    }

    public ItemStore<R> getNullableItemStore() {
        return this.getInformerConfig().getItemStore();
    }

    public InformerConfiguration<R> getInformerConfig() {
        return this.informerConfig;
    }

    public static final class DefaultRateLimiter
    extends LinearRateLimiter {
        public DefaultRateLimiter() {
        }

        @RecordableConstructor
        public DefaultRateLimiter(Duration refreshPeriod, int limitForPeriod) {
            super(refreshPeriod, limitForPeriod);
        }
    }
}

