/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.quarkiverse.operatorsdk.runtime.CRDInfo;
import io.quarkus.runtime.annotations.IgnoreProperty;
import io.quarkus.runtime.annotations.RecordableConstructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CRDInfos {
    private final Map<String, Map<String, CRDInfo>> infos;

    public CRDInfos() {
        this(new ConcurrentHashMap<String, Map<String, CRDInfo>>());
    }

    public CRDInfos(CRDInfos other) {
        this(new ConcurrentHashMap<String, Map<String, CRDInfo>>(other.infos));
    }

    @RecordableConstructor
    private CRDInfos(Map<String, Map<String, CRDInfo>> infos) {
        this.infos = infos;
    }

    @IgnoreProperty
    public Map<String, CRDInfo> getOrCreateCRDSpecVersionToInfoMapping(String crdName) {
        return this.infos.computeIfAbsent(crdName, k -> new HashMap());
    }

    @IgnoreProperty
    public Map<String, CRDInfo> getCRDNameToInfoMappings() {
        return this.infos.values().stream().flatMap(entry -> entry.values().stream().filter(crdInfo -> "v1".equals(crdInfo.getCrdSpecVersion()))).collect(Collectors.toMap(CRDInfo::getCrdName, Function.identity()));
    }

    public void addCRDInfo(CRDInfo crdInfo) {
        this.getOrCreateCRDSpecVersionToInfoMapping(crdInfo.getCrdName()).put(crdInfo.getCrdSpecVersion(), crdInfo);
    }

    public Map<String, Map<String, CRDInfo>> getInfos() {
        return this.infos;
    }

    public boolean contains(String crdId) {
        return this.infos.containsKey(crdId);
    }
}

