/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResourceFactory;
import io.quarkiverse.operatorsdk.runtime.CRDGenerationInfo;
import io.quarkiverse.operatorsdk.runtime.DependentResourceSpecMetadata;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.Version;
import io.quarkus.runtime.annotations.IgnoreProperty;
import java.util.List;
import java.util.Set;

public class BuildTimeConfigurationService
implements ConfigurationService,
DependentResourceFactory<QuarkusControllerConfiguration<?>, DependentResourceSpecMetadata<?, ?, ?>> {
    private final Version version;
    private final CRDGenerationInfo crdInfo;
    private final boolean startOperator;
    private final boolean closeClientOnStop;
    private final boolean stopOnInformerErrorDuringStartup;
    private final boolean enableSSA;
    private final List<String> leaderElectionActivationProfiles;
    private final boolean defensiveCloning;

    public BuildTimeConfigurationService(Version version, CRDGenerationInfo crdInfo, boolean startOperator, boolean closeClientOnStop, boolean stopOnInformerErrorDuringStartup, boolean enableSSA, List<String> leaderElectionActivationProfiles, boolean defensiveCloning) {
        this.version = version;
        this.crdInfo = crdInfo;
        this.startOperator = startOperator;
        this.closeClientOnStop = closeClientOnStop;
        this.stopOnInformerErrorDuringStartup = stopOnInformerErrorDuringStartup;
        this.enableSSA = enableSSA;
        this.leaderElectionActivationProfiles = leaderElectionActivationProfiles;
        this.defensiveCloning = defensiveCloning;
    }

    public <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler) {
        throw new UnsupportedOperationException();
    }

    @IgnoreProperty
    public Set<String> getKnownReconcilerNames() {
        throw new UnsupportedOperationException();
    }

    public Version getVersion() {
        return this.version;
    }

    public CRDGenerationInfo getCrdInfo() {
        return this.crdInfo;
    }

    public boolean isStartOperator() {
        return this.startOperator;
    }

    public boolean isCloseClientOnStop() {
        return this.closeClientOnStop;
    }

    public boolean isStopOnInformerErrorDuringStartup() {
        return this.stopOnInformerErrorDuringStartup;
    }

    public boolean isEnableSSA() {
        return this.enableSSA;
    }

    public boolean activateLeaderElection(List<String> activeProfiles) {
        return activeProfiles.stream().anyMatch(this.leaderElectionActivationProfiles::contains);
    }

    public List<String> getLeaderElectionActivationProfiles() {
        return this.leaderElectionActivationProfiles;
    }

    public boolean isDefensiveCloning() {
        return this.defensiveCloning;
    }

    public DependentResourceFactory<QuarkusControllerConfiguration<?>, DependentResourceSpecMetadata<?, ?, ?>> dependentResourceFactory() {
        return this;
    }

    public Class<?> associatedResourceType(DependentResourceSpecMetadata spec) {
        return spec.getResourceClass();
    }
}

