/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.playwright.deployment;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Frame;
import com.microsoft.playwright.Playwright;
import com.microsoft.playwright.impl.driver.jar.DriverJar;
import com.microsoft.playwright.options.HttpHeader;
import com.microsoft.playwright.options.Timing;
import com.microsoft.playwright.options.ViewportSize;
import io.quarkiverse.playwright.PlaywrightRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageEnableAllCharsetsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.logging.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class PlaywrightProcessor {
    private static final String FEATURE = "playwright";

    PlaywrightProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("com.microsoft.playwright", "driver"));
        index.produce((BuildItem)new IndexDependencyBuildItem("com.microsoft.playwright", "driver-bundle"));
        index.produce((BuildItem)new IndexDependencyBuildItem("com.microsoft.playwright", FEATURE));
    }

    @BuildStep
    NativeImageEnableAllCharsetsBuildItem enableAllCharsetsBuildItem() {
        return new NativeImageEnableAllCharsetsBuildItem();
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add("com.microsoft.playwright.impl.Message");
        classNames.add("com.microsoft.playwright.impl.SerializedArgument");
        classNames.add("com.microsoft.playwright.impl.SerializedValue");
        classNames.add("com.microsoft.playwright.impl.SerializedValue$O");
        classNames.add(Browser.CloseOptions.class.getName());
        classNames.add(Browser.NewContextOptions.class.getName());
        classNames.add(Browser.NewPageOptions.class.getName());
        classNames.add(Browser.StartTracingOptions.class.getName());
        classNames.add(DriverJar.class.getName());
        classNames.add(ElementHandle.CheckOptions.class.getName());
        classNames.add(ElementHandle.ClickOptions.class.getName());
        classNames.add(ElementHandle.DblclickOptions.class.getName());
        classNames.add(ElementHandle.FillOptions.class.getName());
        classNames.add(ElementHandle.HoverOptions.class.getName());
        classNames.add(ElementHandle.InputValueOptions.class.getName());
        classNames.add(ElementHandle.PressOptions.class.getName());
        classNames.add(ElementHandle.ScreenshotOptions.class.getName());
        classNames.add(ElementHandle.ScrollIntoViewIfNeededOptions.class.getName());
        classNames.add(ElementHandle.SelectTextOptions.class.getName());
        classNames.add(ElementHandle.SetCheckedOptions.class.getName());
        classNames.add(ElementHandle.SetInputFilesOptions.class.getName());
        classNames.add(ElementHandle.TapOptions.class.getName());
        classNames.add(ElementHandle.TypeOptions.class.getName());
        classNames.add(ElementHandle.UncheckOptions.class.getName());
        classNames.add(ElementHandle.WaitForElementStateOptions.class.getName());
        classNames.add(ElementHandle.WaitForSelectorOptions.class.getName());
        classNames.add(HttpHeader.class.getName());
        classNames.add(Timing.class.getName());
        classNames.add(ViewportSize.class.getName());
        classNames.add(Frame.AddScriptTagOptions.class.getName());
        classNames.add(Frame.AddStyleTagOptions.class.getName());
        classNames.add(Frame.CheckOptions.class.getName());
        classNames.add(Frame.ClickOptions.class.getName());
        classNames.add(Frame.DblclickOptions.class.getName());
        classNames.add(Frame.DispatchEventOptions.class.getName());
        classNames.add(Frame.FillOptions.class.getName());
        classNames.add(Frame.FocusOptions.class.getName());
        classNames.add(Frame.GetAttributeOptions.class.getName());
        classNames.add(Frame.GetByRoleOptions.class.getName());
        classNames.add(Frame.GetByTextOptions.class.getName());
        classNames.add(Frame.HoverOptions.class.getName());
        classNames.add(Frame.InnerHTMLOptions.class.getName());
        classNames.add(Frame.InnerTextOptions.class.getName());
        classNames.add(Frame.InputValueOptions.class.getName());
        classNames.add(Frame.IsVisibleOptions.class.getName());
        classNames.add(Frame.LocatorOptions.class.getName());
        classNames.add(Frame.PressOptions.class.getName());
        classNames.add(Frame.SelectOptionOptions.class.getName());
        classNames.add(Frame.SetContentOptions.class.getName());
        classNames.add(Frame.SetInputFilesOptions.class.getName());
        classNames.add(Frame.TapOptions.class.getName());
        classNames.add(Frame.TextContentOptions.class.getName());
        classNames.add(Frame.TypeOptions.class.getName());
        classNames.add(Frame.UncheckOptions.class.getName());
        classNames.add(Frame.UncheckOptions.class.getName());
        classNames.add(Frame.WaitForFunctionOptions.class.getName());
        classNames.add(Frame.WaitForLoadStateOptions.class.getName());
        classNames.add(Frame.WaitForSelectorOptions.class.getName());
        classNames.add(Frame.WaitForURLOptions.class.getName());
        classNames.addAll(this.collectImplementors(combinedIndex, Playwright.class.getName()));
        TreeSet uniqueClasses = new TreeSet(classNames);
        Log.debugf((String)"Playwright Reflection: %s", uniqueClasses);
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])uniqueClasses.toArray(new String[0])).constructors().methods().fields().serialization().unsafeAllocated().build());
    }

    @BuildStep(onlyIf={IsNormal.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerRuntimeDrivers(PlaywrightRecorder recorder) {
        recorder.initialize();
    }

    @BuildStep(onlyIf={IsNormal.class})
    void registerNativeDrivers(BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns) {
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("driver/**");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
    }

    private List<String> collectSubclasses(CombinedIndexBuildItem combinedIndex, String className) {
        List<String> classes = combinedIndex.getIndex().getAllKnownSubclasses(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toList());
        classes.add(className);
        Log.debugf((String)"Subclasses: %s", classes);
        return classes;
    }

    private List<String> collectImplementors(CombinedIndexBuildItem combinedIndex, String className) {
        Set classes = combinedIndex.getIndex().getAllKnownImplementors(DotName.createSimple((String)className)).stream().map(ClassInfo::toString).collect(Collectors.toCollection(HashSet::new));
        classes.add(className);
        HashSet<String> subclasses = new HashSet<String>();
        for (String implementationClass : classes) {
            subclasses.addAll(this.collectSubclasses(combinedIndex, implementationClass));
        }
        classes.addAll(subclasses);
        Log.debugf((String)"Implementors: %s", (Object)classes);
        return new ArrayList<String>(classes);
    }
}

