/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.playwright;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserContext;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Playwright;
import io.quarkiverse.playwright.BrowserContextConfig;
import io.quarkiverse.playwright.InjectPlaywright;
import io.quarkiverse.playwright.PlaywrightSelector;
import io.quarkiverse.playwright.WithPlaywright;
import io.quarkus.test.common.QuarkusTestResourceConfigurableLifecycleManager;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class QuarkusPlaywrightManager
implements QuarkusTestResourceConfigurableLifecycleManager<WithPlaywright> {
    private WithPlaywright options;
    private Playwright playwright;
    private BrowserContext playwrightContext;
    private Browser playwrightBrowser;

    public void init(WithPlaywright withPlaywright) {
        this.options = withPlaywright;
    }

    public void init(Map<String, String> initArgs) {
        throw new IllegalStateException("Use @WithPlaywright() annotation instead");
    }

    public Map<String, String> start() {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (!env.containsKey("DEBUG") && this.options.verbose()) {
            env.put("DEBUG", "pw:api");
        }
        if (!env.containsKey("PWDEBUG") && this.options.debug()) {
            env.put("PWDEBUG", "1");
        }
        this.playwright = Playwright.create((Playwright.CreateOptions)new Playwright.CreateOptions().setEnv(env));
        this.playwright.selectors().setTestIdAttribute(this.options.testId());
        for (PlaywrightSelector selector : this.options.selectors()) {
            this.playwright.selectors().register(selector.name(), selector.script());
        }
        BrowserType.LaunchOptions launchOptions = new BrowserType.LaunchOptions().setChannel(this.options.channel()).setChromiumSandbox(this.options.chromiumSandbox()).setHeadless(this.options.headless()).setSlowMo(this.options.slowMo()).setEnv(env).setArgs(Arrays.asList(this.options.args()));
        this.playwrightBrowser = QuarkusPlaywrightManager.browser(this.playwright, this.options.browser()).launch(launchOptions);
        Browser.NewContextOptions contextOptions = new Browser.NewContextOptions();
        if (StringUtils.isNotBlank((CharSequence)this.options.recordVideoDir())) {
            contextOptions.setRecordVideoDir(Paths.get(this.options.recordVideoDir(), new String[0]));
        }
        QuarkusPlaywrightManager.applyBrowserContextConfig(contextOptions, this.options.browserContext());
        this.playwrightContext = this.playwrightBrowser.newContext(contextOptions);
        this.applyConfig();
        return Collections.emptyMap();
    }

    private static void applyBrowserContextConfig(Browser.NewContextOptions contextOptions, BrowserContextConfig config) {
        contextOptions.setOffline(config.offline());
        if (StringUtils.isNotBlank((CharSequence)config.locale())) {
            contextOptions.setLocale(config.locale());
        }
        if (StringUtils.isNotBlank((CharSequence)config.userAgent())) {
            contextOptions.setUserAgent(config.userAgent());
        }
    }

    private void applyConfig() {
        BrowserContextConfig browserContextConfig = this.options.browserContext();
        if (StringUtils.isNotBlank((CharSequence)browserContextConfig.defaultNavigationTimeout())) {
            this.playwrightContext.setDefaultNavigationTimeout((double)Duration.parse(browserContextConfig.defaultNavigationTimeout()).toMillis());
        }
        if (StringUtils.isNotBlank((CharSequence)browserContextConfig.defaultTimeout())) {
            this.playwrightContext.setDefaultTimeout((double)Duration.parse(browserContextConfig.defaultTimeout()).toMillis());
        }
    }

    private static BrowserType browser(Playwright playwright, WithPlaywright.Browser browser) {
        return switch (browser) {
            case WithPlaywright.Browser.FIREFOX -> playwright.firefox();
            case WithPlaywright.Browser.WEBKIT -> playwright.webkit();
            default -> playwright.chromium();
        };
    }

    public void stop() {
        if (this.playwrightContext != null) {
            this.playwrightContext.close();
            this.playwrightContext = null;
        }
        if (this.playwright != null) {
            this.playwright.close();
            this.playwright = null;
        }
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.playwrightContext, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectPlaywright.class, BrowserContext.class));
        testInjector.injectIntoFields((Object)this.playwright, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectPlaywright.class, Playwright.class));
        testInjector.injectIntoFields((Object)this.playwrightBrowser, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(InjectPlaywright.class, Browser.class));
    }
}

