/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.playwright.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.logging.Log;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

@TargetClass(className="com.microsoft.playwright.impl.LoggingSupport")
final class LoggingSupportSubstitution {
    @Alias
    private static boolean isEnabled;
    @Alias
    private static DateTimeFormatter timestampFormat;

    LoggingSupportSubstitution() {
    }

    @Substitute
    static void logWithTimestamp(String message) {
        String timestamp = ZonedDateTime.now().format(timestampFormat);
        Log.infof((String)"%s %s", (Object)timestamp, (Object)message);
    }

    @Substitute
    static void logApiIfEnabled(String message) {
        if (isEnabled) {
            LoggingSupportSubstitution.logApi(message);
        }
    }

    @Substitute
    static void logApi(String message) {
        LoggingSupportSubstitution.logWithTimestamp("pw:api " + message);
    }
}

