/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.playwright;

import com.microsoft.playwright.impl.driver.jar.DriverJar;
import io.quarkus.runtime.annotations.Recorder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Collections;
import org.jboss.logging.Logger;

@Recorder
public class PlaywrightRecorder {
    private static final Logger log = Logger.getLogger(PlaywrightRecorder.class);

    public void initialize() {
        try {
            URI uri = DriverJar.getDriverResourceURI();
            log.infof("Playwright Driver: %s", (Object)uri);
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            if (fs == null) {
                log.errorf("FileSystem Error NULL: %s", (Object)uri);
            }
            DriverJar jar = new DriverJar();
            log.debugf("Playwright Driver Directory: %s", (Object)jar.driverDir());
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

