/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.primefaces.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.primefaces.runtime.PrimeFacesFeature;
import io.quarkus.primefaces.runtime.PrimeFacesRecorder;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.krysalis.barcode4j.output.bitmap.ImageIOBitmapEncoder;
import org.primefaces.application.exceptionhandler.ExceptionInfo;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.component.fileupload.NativeFileUploadDecoder;
import org.primefaces.component.organigram.OrganigramHelper;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.file.CommonsUploadedFile;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.seo.JsonLD;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ChartUtils;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.Constants;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.ELUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.HtmlSanitizer;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.ResourceUtils;
import org.primefaces.util.SecurityUtils;

class PrimefacesProcessor {
    private static final String FEATURE = "primefaces";

    PrimefacesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(PrimeFacesFeature.class);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("com.googlecode.owasp-java-html-sanitizer", "owasp-java-html-sanitizer"));
        index.produce((BuildItem)new IndexDependencyBuildItem("io.nayuki", "qrcodegen"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.primefaces.extensions", "barcode4j-light"));
    }

    @BuildStep
    void produceApplicationArchiveMarker(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalArchiveMarkers) {
        additionalArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("org/primefaces/component"));
    }

    @BuildStep
    void substrateResourceBuildItems(BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/maven/org.primefaces/primefaces/pom.properties", "META-INF/primefaces-p.taglib.xml", "META-INF/faces-config.xml", "META-INF/web-fragment.xml", "META-INF/web.xml", "META-INF/LICENSE.txt", "META-INF/NOTICE.txt", "META-INF/services/org.primefaces.component.fileupload.FileUploadDecoder", "META-INF/services/org.primefaces.virusscan.VirusScanner"}));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_cs"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_de"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_el"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_en"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_es"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_fa"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_fr"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_hi"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_in"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_it"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ka"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ko"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_lv"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_nl"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_no"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_pl"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_pt"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ro"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ru"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_sk"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_sv"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_tr"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_zh"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerForReflection(PrimeFacesRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>(List.of(SearchExpressionUtils.class.getName(), SearchExpressionFacade.class.getName(), PrimeClientWindowUtils.class.getName(), RendererUtils.class.getName(), JsonLD.class.getName(), AgentUtils.class.getName(), BeanUtils.class.getName(), CalendarUtils.class.getName(), ChartUtils.class.getName(), ComponentTraversalUtils.class.getName(), ComponentUtils.class.getName(), CompositeUtils.class.getName(), Constants.class.getName(), DynamicContentSrcBuilder.class.getName(), ELUtils.class.getName(), EscapeUtils.class.getName(), FileUploadUtils.class.getName(), GridLayoutUtils.class.getName(), HtmlSanitizer.class.getName(), IOUtils.class.getName(), LangUtils.class.getName(), LocaleUtils.class.getName(), MessageFactory.class.getName(), ResourceUtils.class.getName(), SecurityUtils.class.getName()));
        List<String> models = this.collectClassesInPackage(combinedIndex, "org.primefaces.model");
        models.remove(CommonsUploadedFile.class.getName());
        classNames.addAll(models);
        classNames.add(NativeFileUploadDecoder.class.getName());
        classNames.add(ExceptionInfo.class.getName());
        classNames.add(OrganigramHelper.class.getName());
        classNames.add("javax.imageio.ImageIO");
        classNames.add(ImageIOBitmapEncoder.class.getName());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods(true).fields(true).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{PrimeEnvironment.class.getName()}).build());
    }

    @BuildStep
    void enforceInitParams(BuildProducer<ServletInitParamBuildItem> initParam) {
        initParam.produce((BuildItem)new ServletInitParamBuildItem("primefaces.UPLOADER", "native"));
    }

    public List<String> collectClassesInPackage(CombinedIndexBuildItem combinedIndex, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<DotName> packages = new ArrayList<DotName>(combinedIndex.getIndex().getSubpackages(packageName));
        packages.add(DotName.createSimple((String)packageName));
        for (DotName aPackage : packages) {
            List<String> packageClasses = combinedIndex.getIndex().getClassesInPackage(aPackage).stream().map(ClassInfo::toString).toList();
            classes.addAll(packageClasses);
        }
        return classes;
    }
}

