/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.primefaces.deployment;

import io.quarkiverse.primefaces.deployment.AbstractJandexProcessor;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.primefaces.runtime.PrimeFacesFeature;
import io.quarkus.primefaces.runtime.PrimeFacesRecorder;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.application.exceptionhandler.ExceptionInfo;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.component.api.IterationStatus;
import org.primefaces.component.api.SavedState;
import org.primefaces.component.api.UITableState;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.fileupload.NativeFileUploadDecoder;
import org.primefaces.component.organigram.OrganigramHelper;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.file.CommonsUploadedFile;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.seo.JsonLD;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.Constants;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.ELUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.HtmlSanitizer;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.PropertyDescriptorResolver;
import org.primefaces.util.ResourceUtils;
import org.primefaces.util.SecurityUtils;

class PrimeFacesProcessor
extends AbstractJandexProcessor {
    private static final String FEATURE = "primefaces";

    PrimeFacesProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(PrimeFacesFeature.class);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("com.googlecode.owasp-java-html-sanitizer", "owasp-java-html-sanitizer"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.primefaces", FEATURE));
        index.produce((BuildItem)new IndexDependencyBuildItem("software.xdev", "chartjs-java-model"));
    }

    @BuildStep
    void produceApplicationArchiveMarker(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalArchiveMarkers) {
        additionalArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("org/primefaces/component"));
    }

    @BuildStep(onlyIf={IsNormal.class})
    void uberJarServiceLoaders(BuildProducer<UberJarMergedResourceBuildItem> producer) {
        List<String> serviceFiles = List.of("services/org.primefaces.component.fileupload.FileUploadDecoder", "services/org.primefaces.util.PropertyDescriptorResolver", "services/org.primefaces.virusscan.VirusScanner", "maven/org.json/json/pom.properties", "maven/org.json/json/pom.xml", "maven/org.jctools/jctools-core/pom.properties", "maven/org.jctools/jctools-core/pom.xml");
        for (String serviceFile : serviceFiles) {
            producer.produce((BuildItem)new UberJarMergedResourceBuildItem("META-INF/" + serviceFile));
        }
    }

    @BuildStep
    void substrateResourceBuildItems(BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/maven/org.primefaces/primefaces/pom.properties", "META-INF/primefaces.taglib.xml", "META-INF/primefaces.urn.taglib.xml", "META-INF/faces-config.xml", "META-INF/web-fragment.xml", "META-INF/web.xml", "META-INF/LICENSE.txt", "META-INF/NOTICE.txt", "META-INF/services/org.primefaces.component.fileupload.FileUploadDecoder", "META-INF/services/org.primefaces.util.PropertyDescriptorResolver", "META-INF/services/org.primefaces.virusscan.VirusScanner"}));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_cs"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_de"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_el"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_en"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_es"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_fa"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_fr"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_hi"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_in"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_it"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ka"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ko"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_lv"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_nl"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_no"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_pl"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_pt"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ro"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_ru"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_sk"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_sv"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_tr"));
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.Messages_zh"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerForReflection(PrimeFacesRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>(List.of(IterationStatus.class.getName(), SearchExpressionUtils.class.getName(), PrimeClientWindowUtils.class.getName(), RendererUtils.class.getName(), JsonLD.class.getName(), AgentUtils.class.getName(), BeanUtils.class.getName(), CalendarUtils.class.getName(), ComponentTraversalUtils.class.getName(), ComponentUtils.class.getName(), CompositeUtils.class.getName(), Constants.class.getName(), DynamicContentSrcBuilder.class.getName(), ELUtils.class.getName(), EscapeUtils.class.getName(), FileUploadUtils.class.getName(), GridLayoutUtils.class.getName(), HtmlSanitizer.class.getName(), IOUtils.class.getName(), LangUtils.class.getName(), LocaleUtils.class.getName(), MessageFactory.class.getName(), ResourceUtils.class.getName(), SecurityUtils.class.getName(), PropertyDescriptorResolver.DefaultResolver.class.getName()));
        classNames.add(NativeFileUploadDecoder.class.getName());
        classNames.add(ExceptionInfo.class.getName());
        classNames.add(OrganigramHelper.class.getName());
        classNames.addAll(this.collectImplementors(combinedIndex, PropertyDescriptorResolver.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, Exporter.class.getName()));
        classNames.addAll(this.collectImplementors(combinedIndex, ExporterOptions.class.getName()));
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods().fields().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{PrimeEnvironment.class.getName()}).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerForSerialization(PrimeFacesRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        List<String> models = this.collectClassesInPackage(combinedIndex, "org.primefaces.model");
        models.remove(CommonsUploadedFile.class.getName());
        ArrayList<String> classNames = new ArrayList<String>(models);
        classNames.addAll(this.collectClassesInPackage(combinedIndex, "software.xdev.chartjs.model"));
        classNames.add(SavedState.class.getName());
        classNames.add(UITableState.class.getName());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[0])).methods().fields().serialization().build());
    }

    @BuildStep
    void enforceInitParams(BuildProducer<ServletInitParamBuildItem> initParam) {
        initParam.produce((BuildItem)new ServletInitParamBuildItem("primefaces.UPLOADER", "native"));
    }
}

