/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.primefaces.extensions.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.primefaces.extensions.runtime.PrimeFacesExtensionsFeature;
import io.quarkus.primefaces.extensions.runtime.PrimeFacesExtensionsRecorder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.primefaces.extensions.config.PrimeExtensionsEnvironment;

class PrimefacesExtensionsProcessor {
    private static final String FEATURE = "primefaces-extensions";

    PrimefacesExtensionsProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    NativeImageFeatureBuildItem nativeImageFeature() {
        return new NativeImageFeatureBuildItem(PrimeFacesExtensionsFeature.class);
    }

    @BuildStep
    void indexTransitiveDependencies(BuildProducer<IndexDependencyBuildItem> index) {
        index.produce((BuildItem)new IndexDependencyBuildItem("org.primefaces.extensions", "resources-monacoeditor"));
        index.produce((BuildItem)new IndexDependencyBuildItem("com.google.code.gson", "gson"));
        index.produce((BuildItem)new IndexDependencyBuildItem("com.googlecode.libphonenumber", "libphonenumber"));
        index.produce((BuildItem)new IndexDependencyBuildItem("com.googlecode.owasp-java-html-sanitizer", "owasp-java-html-sanitizer"));
        index.produce((BuildItem)new IndexDependencyBuildItem("dev.morphia.morphia", "morphia-core"));
        index.produce((BuildItem)new IndexDependencyBuildItem("org.commonmark", "commonmark"));
    }

    @BuildStep
    void produceApplicationArchiveMarker(BuildProducer<AdditionalApplicationArchiveMarkerBuildItem> additionalArchiveMarkers) {
        additionalArchiveMarkers.produce((BuildItem)new AdditionalApplicationArchiveMarkerBuildItem("org/primefaces/extensions/component"));
    }

    @BuildStep
    void substrateResourceBuildItems(BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<NativeImageResourceBundleBuildItem> resourceBundleBuildItem, BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResourcePatterns) {
        nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/maven/org.primefaces.extensions/primefaces-extensions/pom.properties", "META-INF/primefaces-extensions.taglib.xml", "META-INF/faces-config.xml", "META-INF/LICENSE.txt", "META-INF/NOTICE.txt"}));
        NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
        builder.includeGlob("**/phonenumbers/data/**");
        builder.includeGlob("pfe-localized/**");
        nativeImageResourcePatterns.produce((BuildItem)builder.build());
        resourceBundleBuildItem.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.primefaces.extensions.Messages"));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerForReflection(PrimeFacesExtensionsRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, CombinedIndexBuildItem combinedIndex) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(this.collectClassesInPackage(combinedIndex, "org.primefaces.extensions.util"));
        classNames.addAll(this.collectClassesInPackage(combinedIndex, "org.primefaces.extensions.model"));
        classNames.add(Locale.class.getName());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])classNames.toArray(new String[classNames.size()])).methods(true).fields(true).build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{PrimeExtensionsEnvironment.class.getName()}).build());
    }

    public List<String> collectClassesInPackage(CombinedIndexBuildItem combinedIndex, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<DotName> packages = new ArrayList<DotName>(combinedIndex.getIndex().getSubpackages(packageName));
        packages.add(DotName.createSimple((String)packageName));
        for (DotName aPackage : packages) {
            List packageClasses = combinedIndex.getIndex().getClassesInPackage(aPackage).stream().map(ClassInfo::toString).collect(Collectors.toList());
            classes.addAll(packageClasses);
        }
        return classes;
    }
}

