/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.testing;

import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.test.QuarkusUnitTest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;

public class QuinoaQuarkusUnitTest {
    public static final String TARGET_TEST_WEBUI = "target/test-webui";
    private static final String CI = System.getProperty("CI");
    private final Path testDir;
    private boolean alreadyInstalled = false;
    private String initialLockfile = "package-lock.json";
    private Boolean ci = false;

    private QuinoaQuarkusUnitTest(Path testDir) {
        this.testDir = testDir;
    }

    public static QuinoaQuarkusUnitTest create(String name) {
        return new QuinoaQuarkusUnitTest(QuinoaQuarkusUnitTest.getWebUITestDirPath(name));
    }

    public static QuinoaQuarkusUnitTest create(Path uiDir) {
        return new QuinoaQuarkusUnitTest(uiDir);
    }

    public QuinoaQuarkusUnitTest initialLockfile(String lockFile) {
        this.initialLockfile = lockFile;
        return this;
    }

    public QuinoaQuarkusUnitTest alreadyInstalled() {
        this.alreadyInstalled = true;
        return this;
    }

    public QuinoaQuarkusUnitTest noLockfile() {
        this.initialLockfile = null;
        return this;
    }

    public QuinoaQuarkusUnitTest ci(Boolean ci) {
        this.ci = ci;
        return this;
    }

    public QuarkusUnitTest toQuarkusUnitTest() {
        return new QuarkusUnitTest().setAllowTestClassOutsideDeployment(true).setBeforeAllCustomizer(new Runnable(){

            @Override
            public void run() {
                QuinoaQuarkusUnitTest.prepareTestWebUI(QuinoaQuarkusUnitTest.this.testDir, QuinoaQuarkusUnitTest.this.alreadyInstalled);
                QuinoaQuarkusUnitTest.prepareLockFile(QuinoaQuarkusUnitTest.this.testDir, QuinoaQuarkusUnitTest.this.initialLockfile);
                if (QuinoaQuarkusUnitTest.this.ci != null) {
                    System.setProperty("CI", QuinoaQuarkusUnitTest.this.ci.toString());
                }
            }
        }).setAfterAllCustomizer(new Runnable(){

            @Override
            public void run() {
                QuinoaQuarkusUnitTest.safeCleanProperty("ci", CI);
            }
        }).setLogRecordPredicate(log -> true).overrideConfigKey("quarkus.quinoa.ui-dir", this.testDir.toString());
    }

    public static Path getWebUITestDirPath(String name) {
        return Path.of("target/test-webui-" + name, new String[0]);
    }

    public static String systemBinary(String base) {
        return QuinoaQuarkusUnitTest.isWindows() ? base + ".cmd" : base;
    }

    public static boolean isWindows() {
        return QuarkusConsole.IS_WINDOWS;
    }

    public static void prepareTestWebUI(Path testDir, boolean installed) {
        Path webUI = Path.of("src/test/webui/", new String[0]);
        try {
            FileUtil.deleteDirectory((Path)testDir);
            Files.createDirectories(testDir, new FileAttribute[0]);
            PathUtils.copyDirectory((Path)webUI, (Path)testDir, (CopyOption[])new CopyOption[0]);
            if (installed) {
                Files.createDirectory(testDir.resolve("node_modules"), new FileAttribute[0]);
                Path targetQuinoaDir = Path.of("target/quinoa/", new String[0]);
                Files.createDirectories(targetQuinoaDir, new FileAttribute[0]);
                Files.copy(testDir.resolve("package.json"), targetQuinoaDir.resolve("package.json"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while preparing the test web ui directory.", e);
        }
    }

    private static void safeCleanProperty(String name, String value) {
        if (value == null) {
            System.clearProperty(name);
        } else {
            System.setProperty(name, value);
        }
    }

    private static void prepareLockFile(Path testDir, String toUse) {
        if (toUse != null) {
            try {
                PathUtils.copyFileToDirectory((Path)Path.of("src/test/resources/lockfiles/", toUse), (Path)testDir, (CopyOption[])new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

