/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jboss.logging.Logger;

public class PackageManager {
    private static final Logger LOG = Logger.getLogger(PackageManager.class);
    private static final Commands NPM = new NPMCommands();
    private static final Commands YARN = new YarnCommands();
    private final String packageManagerBinary;
    private final Path directory;
    private final Commands commands;

    public PackageManager(String packageManagerBinary, Path directory) {
        this.packageManagerBinary = packageManagerBinary;
        this.directory = directory;
        this.commands = PackageManager.detect(packageManagerBinary);
    }

    public boolean install(boolean frozenLockfile) {
        Command install = this.commands.install(frozenLockfile);
        LOG.infof("Running Quinoa install command: %s %s", (Object)this.packageManagerBinary, (Object)String.join((CharSequence)" ", install.args));
        return this.exec(install);
    }

    public boolean build() {
        Command build = this.commands.build();
        LOG.infof("Running Quinoa build command: %s %s", (Object)this.packageManagerBinary, (Object)String.join((CharSequence)" ", build.args));
        return this.exec(build);
    }

    public boolean test() {
        Command test = this.commands.test();
        LOG.infof("Running Quinoa test command: %s %s", (Object)this.packageManagerBinary, (Object)String.join((CharSequence)" ", test.args));
        return this.exec(test);
    }

    static Commands detect(String binary) {
        if (binary.contains("npm")) {
            return NPM;
        }
        if (binary.contains("yarn")) {
            return YARN;
        }
        throw new UnsupportedOperationException("Unsupported package manager binary: " + binary);
    }

    private boolean exec(Command command) {
        Process process = null;
        try {
            String[] cmd = new String[command.args.length + 1];
            cmd[0] = this.packageManagerBinary;
            if (command.args.length > 0) {
                System.arraycopy(command.args, 0, cmd, 1, command.args.length);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (!command.envs.isEmpty()) {
                processBuilder.environment().putAll(command.envs);
            }
            process = processBuilder.directory(this.directory.toFile()).command(cmd).redirectErrorStream(true).start();
            new HandleOutput(process.getInputStream()).run();
            process.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return process != null && process.exitValue() == 0;
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Logger.Level logLevel;

        HandleOutput(InputStream is) {
            this(is, Logger.Level.INFO);
        }

        HandleOutput(InputStream is, Logger.Level logLevel) {
            this.is = is;
            this.logLevel = LOG.isEnabled(logLevel) ? logLevel : null;
        }

        @Override
        public void run() {
            block14: {
                try (InputStreamReader isr = new InputStreamReader(this.is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        if (this.logLevel != null) {
                            LOG.log(this.logLevel, (Object)line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (this.logLevel == null) break block14;
                    LOG.log(this.logLevel, (Object)"Failed to handle output", (Throwable)e);
                }
            }
        }
    }

    private static class YarnCommands
    implements Commands {
        private YarnCommands() {
        }

        @Override
        public Command install(boolean frozenLockfile) {
            if (frozenLockfile) {
                return new Command("ci");
            }
            return new Command("install");
        }

        @Override
        public Command build() {
            return new Command("build");
        }

        @Override
        public Command test() {
            return new Command(Collections.singletonMap("CI", "true"), "test");
        }
    }

    private static class NPMCommands
    implements Commands {
        private NPMCommands() {
        }

        @Override
        public Command install(boolean frozenLockfile) {
            if (frozenLockfile) {
                return new Command("install", "--frozen-lockfile");
            }
            return new Command("install");
        }

        @Override
        public Command build() {
            return new Command("run", "build");
        }

        @Override
        public Command test() {
            return new Command(Collections.singletonMap("CI", "true"), "test");
        }
    }

    static interface Commands {
        public Command install(boolean var1);

        public Command build();

        public Command test();
    }

    private static class Command {
        public final Map<String, String> envs;
        public final String[] args;

        private Command(String ... args) {
            this.envs = Collections.emptyMap();
            this.args = args;
        }

        private Command(Map<String, String> envs, String ... args) {
            this.envs = envs;
            this.args = args;
        }
    }
}

