/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.QuinoaRecorder;
import io.quarkiverse.quinoa.deployment.PackageManager;
import io.quarkiverse.quinoa.deployment.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.SrcUIDirBuildItem;
import io.quarkiverse.quinoa.deployment.UIBuildOutcomeBuildItem;
import io.quarkiverse.quinoa.deployment.UIResourcesBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class QuinoaProcessor {
    private static final Logger log = Logger.getLogger(QuinoaProcessor.class);
    private static final String FEATURE = "quinoa";
    private static final String TARGET_DIR_NAME = "quinoa-build";
    private static final Set<String> IGNORE_WATCH = Set.of("node_modules", "build", "target", "dist");

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public SrcUIDirBuildItem prepareSrcUI(LaunchModeBuildItem launchModeBuildItem, QuinoaConfig quinoaConfig, OutputTargetBuildItem outputTargetBuildItem) throws IOException {
        if (!quinoaConfig.enable.orElse(true).booleanValue()) {
            return null;
        }
        if (launchModeBuildItem.isTest() && !quinoaConfig.enable.isPresent()) {
            return null;
        }
        AbstractMap.SimpleEntry<Path, Path> srcUIDirEntry = this.getUIDir(quinoaConfig, outputTargetBuildItem);
        if (srcUIDirEntry == null || !Files.isDirectory(srcUIDirEntry.getKey(), new LinkOption[0])) {
            log.warnf("No Quinoa UI directory found. It is recommended to remove the quarkus-quinoa extension if not used.", new Object[0]);
            return null;
        }
        if (!Files.isRegularFile(srcUIDirEntry.getKey().resolve("package.json"), new LinkOption[0])) {
            throw new ConfigurationException("No package.json found in UI directory: '" + srcUIDirEntry.getKey() + "'");
        }
        return new SrcUIDirBuildItem(srcUIDirEntry.getKey());
    }

    @BuildStep
    public UIBuildOutcomeBuildItem uiBuild(QuinoaConfig quinoaConfig, Optional<SrcUIDirBuildItem> srcUIDirBuildItem, OutputTargetBuildItem outputTargetBuildItem, LaunchModeBuildItem launchModeBuildItem, LiveReloadBuildItem liveReloadBuildItem) throws IOException, BuildException {
        if (!srcUIDirBuildItem.isPresent()) {
            return null;
        }
        QuinoaLiveContext contextObject = (QuinoaLiveContext)liveReloadBuildItem.getContextObject(QuinoaLiveContext.class);
        if (liveReloadBuildItem.isLiveReload() && liveReloadBuildItem.getChangedResources().stream().noneMatch(r -> r.startsWith(((SrcUIDirBuildItem)((Object)((Object)srcUIDirBuildItem.get()))).getDirectory().toString())) && contextObject != null) {
            return new UIBuildOutcomeBuildItem(contextObject.getLocation());
        }
        String packageManagerBinary = quinoaConfig.packageManager.orElse("npm");
        PackageManager packageManager = new PackageManager(packageManagerBinary, srcUIDirBuildItem.get().getDirectory());
        if (quinoaConfig.alwaysInstallPackages.orElse(!Files.isDirectory(srcUIDirBuildItem.get().getDirectory().resolve("node_modules"), new LinkOption[0])).booleanValue() && !packageManager.install(quinoaConfig.frozenLockfile.orElseGet(() -> Objects.equals(System.getenv("CI"), "true")))) {
            throw new RuntimeException("Error while installing the UI");
        }
        if (quinoaConfig.runUITests.orElse(false).booleanValue() && !packageManager.test()) {
            throw new RuntimeException("Error while testing the UI");
        }
        if (!packageManager.build()) {
            throw new RuntimeException("Error while building the UI");
        }
        Path buildDir = srcUIDirBuildItem.get().getDirectory().resolve(quinoaConfig.buildDir.orElse("build"));
        if (!Files.isDirectory(buildDir, new LinkOption[0])) {
            throw new ConfigurationException("Invalid UI build directory: '" + buildDir + "'");
        }
        Path targetBuildDir = outputTargetBuildItem.getOutputDirectory().resolve(TARGET_DIR_NAME);
        FileUtil.deleteDirectory((Path)targetBuildDir);
        Files.move(buildDir, targetBuildDir, new CopyOption[0]);
        liveReloadBuildItem.setContextObject(QuinoaLiveContext.class, (Object)new QuinoaLiveContext(targetBuildDir));
        return new UIBuildOutcomeBuildItem(targetBuildDir);
    }

    @BuildStep(onlyIf={IsNormal.class})
    public UIResourcesBuildItem prepareResourcesForNormalMode(Optional<UIBuildOutcomeBuildItem> uiBuildOutcomeBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResources) throws IOException {
        if (!uiBuildOutcomeBuildItem.isPresent()) {
            return null;
        }
        return new UIResourcesBuildItem(this.getUIEntries(generatedResources, uiBuildOutcomeBuildItem.get().getUiBuildDirectory()));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public UIResourcesBuildItem prepareResourcesForOtherMode(Optional<UIBuildOutcomeBuildItem> uiBuildOutcomeBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResources) throws IOException {
        if (!uiBuildOutcomeBuildItem.isPresent()) {
            return null;
        }
        HashSet<UIResourcesBuildItem.UIEntry> entries = this.getUIEntries(generatedResources, uiBuildOutcomeBuildItem.get().getUiBuildDirectory());
        return new UIResourcesBuildItem(uiBuildOutcomeBuildItem.get().getUiBuildDirectory(), entries);
    }

    @BuildStep
    void watchChanges(QuinoaConfig quinoaConfig, Optional<SrcUIDirBuildItem> srcUIDirBuildItem, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        if (!srcUIDirBuildItem.isPresent()) {
            return;
        }
        this.scan(srcUIDirBuildItem.get().getDirectory(), watchedPaths);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(Optional<UIResourcesBuildItem> uiResources, QuinoaRecorder recorder, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, BuildProducer<DefaultRouteBuildItem> defaultRoutes, BuildProducer<RouteBuildItem> routes) throws IOException {
        if (uiResources.isPresent() && !uiResources.get().getNames().isEmpty()) {
            String directory = null;
            if (uiResources.get().getDirectory().isPresent()) {
                directory = uiResources.get().getDirectory().get().toAbsolutePath().toString();
            }
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(10000)).handler(recorder.quinoaHandler(directory, uiResources.get().getNames())).build());
        }
    }

    private HashSet<UIResourcesBuildItem.UIEntry> getUIEntries(BuildProducer<GeneratedResourceBuildItem> generatedResources, Path uiDir) throws IOException {
        List files = Files.walk(uiDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        HashSet<UIResourcesBuildItem.UIEntry> entries = new HashSet<UIResourcesBuildItem.UIEntry>(files.size());
        log.infof("Quinoa Build directory: '%s'", (Object)uiDir);
        for (Path file : files) {
            String name = "/" + uiDir.relativize(file);
            log.infof("Quinoa Generated: '%s'", (Object)name);
            generatedResources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/ui" + name, Files.readAllBytes(file), true));
            entries.add(new UIResourcesBuildItem.UIEntry(name));
        }
        return entries;
    }

    private void scan(Path directory, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    log.debugf("Quinoa is watching: %s", (Object)filePath);
                    watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(filePath.toString()));
                    continue;
                }
                if (!Files.isDirectory(filePath, new LinkOption[0]) || IGNORE_WATCH.contains(filePath.getFileName().toString())) continue;
                log.debugf("Quinoa is scanning directory: %s", (Object)filePath);
                this.scan(filePath, watchedPaths);
            }
        }
    }

    private AbstractMap.SimpleEntry<Path, Path> getUIDir(QuinoaConfig quinoaConfig, OutputTargetBuildItem outputTargetBuildItem) {
        AbstractMap.SimpleEntry<Path, Path> mainSourcesRoot = QuinoaProcessor.findMainSourcesRoot(outputTargetBuildItem.getOutputDirectory());
        if (mainSourcesRoot == null) {
            return null;
        }
        Path uiRoot = ((Path)mainSourcesRoot.getKey()).resolve(quinoaConfig.uiDir.orElse("ui"));
        File file = uiRoot.toFile();
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        return new AbstractMap.SimpleEntry<Path, Path>(uiRoot, (Path)mainSourcesRoot.getValue());
    }

    static AbstractMap.SimpleEntry<Path, Path> findMainSourcesRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            Path toCheck;
            if ((toCheck = currentPath.resolve(Paths.get("src", "main"))).toFile().exists()) {
                return new AbstractMap.SimpleEntry<Path, Path>(toCheck, currentPath);
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }

    private static class QuinoaLiveContext {
        private final Path location;

        private QuinoaLiveContext(Path location) {
            this.location = location;
        }

        public Path getLocation() {
            return this.location;
        }
    }
}

