/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class UIResourcesBuildItem
extends SimpleBuildItem {
    private final Optional<Path> directory;
    private final Set<UIEntry> entries;

    public UIResourcesBuildItem(Path directory, Set<UIEntry> entries) {
        this.directory = Optional.ofNullable(directory);
        this.entries = entries;
    }

    public UIResourcesBuildItem(Set<UIEntry> entries) {
        this.directory = Optional.empty();
        this.entries = entries;
    }

    public Optional<Path> getDirectory() {
        return this.directory;
    }

    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>(this.entries.size());
        for (UIEntry entry : this.entries) {
            names.add(entry.getName());
        }
        return names;
    }

    public static class UIEntry {
        private final String name;

        public UIEntry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UIEntry entry = (UIEntry)o;
            return this.name.equals(entry.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

