/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.QuinoaRecorder;
import io.quarkiverse.quinoa.deployment.BuiltResourcesBuildItem;
import io.quarkiverse.quinoa.deployment.PackageManager;
import io.quarkiverse.quinoa.deployment.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.QuinoaDirectoryBuildItem;
import io.quarkiverse.quinoa.deployment.TargetDirBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.resteasy.reactive.server.spi.ResumeOn404BuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class QuinoaProcessor {
    private static final Logger LOG = Logger.getLogger(QuinoaProcessor.class);
    private static final String FEATURE = "quinoa";
    private static final String TARGET_DIR_NAME = "quinoa-build";
    private static final Set<String> IGNORE_WATCH = Set.of("node_modules", "build", "target", "dist");

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public QuinoaDirectoryBuildItem prepareQuinoaDirectory(LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, QuinoaConfig quinoaConfig, OutputTargetBuildItem outputTarget) throws IOException {
        if (!quinoaConfig.isEnabled()) {
            LOG.info((Object)"Quinoa is disabled.");
            return null;
        }
        if (launchMode.isTest() && !quinoaConfig.enable.isPresent()) {
            LOG.warn((Object)"Quinoa is disabled by default in tests.");
            return null;
        }
        String configuredDir = quinoaConfig.getUIDir();
        AbstractMap.SimpleEntry<Path, Path> uiDirEntry = this.computeUIDir(configuredDir, outputTarget);
        if (uiDirEntry == null) {
            LOG.warnf("Quinoa directory not found 'quarkus.quinoa.ui-dir=%s'. It is recommended to remove the quarkus-quinoa extension if not used.", (Object)configuredDir);
            return null;
        }
        Path packageFile = uiDirEntry.getKey().resolve("package.json");
        if (!Files.isRegularFile(packageFile, new LinkOption[0])) {
            throw new ConfigurationException("No package.json found in Web UI directory: '" + configuredDir + "'");
        }
        PackageManager packageManager = PackageManager.autoDetectPackageManager(quinoaConfig.packageManager, uiDirEntry.getKey());
        boolean alreadyInstalled = Files.isDirectory(packageManager.getDirectory().resolve("node_modules"), new LinkOption[0]);
        boolean packageFileModified = liveReload.isLiveReload() && liveReload.getChangedResources().stream().anyMatch(r -> r.equals(packageFile.toString()));
        if (quinoaConfig.alwaysInstall.orElse(!alreadyInstalled || packageFileModified).booleanValue()) {
            boolean frozenLockfile = quinoaConfig.frozenLockfile.orElseGet(QuinoaProcessor::isCI);
            packageManager.install(frozenLockfile);
        }
        return new QuinoaDirectoryBuildItem(packageManager);
    }

    @BuildStep
    public TargetDirBuildItem processBuild(QuinoaConfig quinoaConfig, Optional<QuinoaDirectoryBuildItem> quinoaDir, OutputTargetBuildItem outputTarget, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload) throws IOException, BuildException {
        if (!quinoaDir.isPresent()) {
            return null;
        }
        PackageManager packageManager = quinoaDir.get().getPackageManager();
        QuinoaLiveContext contextObject = (QuinoaLiveContext)liveReload.getContextObject(QuinoaLiveContext.class);
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT && quinoaConfig.devServerPort.isPresent()) {
            return null;
        }
        if (liveReload.isLiveReload() && liveReload.getChangedResources().stream().noneMatch(r -> r.startsWith(packageManager.getDirectory().toString())) && contextObject != null) {
            return new TargetDirBuildItem(contextObject.getLocation());
        }
        if (quinoaConfig.shouldRunTests()) {
            packageManager.test();
        }
        packageManager.build(launchMode.getLaunchMode());
        String configuredBuildDir = quinoaConfig.getBuildDir();
        Path buildDir = packageManager.getDirectory().resolve(configuredBuildDir);
        if (!Files.isDirectory(buildDir, new LinkOption[0])) {
            throw new ConfigurationException("Quinoa build directory not found: '" + configuredBuildDir + "'", Set.of("quarkus.quinoa.build-dir"));
        }
        Path targetBuildDir = outputTarget.getOutputDirectory().resolve(TARGET_DIR_NAME);
        FileUtil.deleteDirectory((Path)targetBuildDir);
        Files.move(buildDir, targetBuildDir, new CopyOption[0]);
        liveReload.setContextObject(QuinoaLiveContext.class, (Object)new QuinoaLiveContext(targetBuildDir));
        return new TargetDirBuildItem(targetBuildDir);
    }

    @BuildStep(onlyIf={IsNormal.class})
    public BuiltResourcesBuildItem prepareResourcesForNormalMode(Optional<TargetDirBuildItem> targetDir, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) throws IOException {
        if (!targetDir.isPresent()) {
            return null;
        }
        return new BuiltResourcesBuildItem(this.prepareBuiltResources(generatedResources, nativeImageResources, targetDir.get().getBuildDirectory()));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public BuiltResourcesBuildItem prepareResourcesForOtherMode(Optional<TargetDirBuildItem> targetDir, BuildProducer<GeneratedResourceBuildItem> generatedResources) throws IOException {
        if (!targetDir.isPresent()) {
            return null;
        }
        HashSet<BuiltResourcesBuildItem.BuiltResource> entries = this.prepareBuiltResources(generatedResources, null, targetDir.get().getBuildDirectory());
        return new BuiltResourcesBuildItem(targetDir.get().getBuildDirectory(), entries);
    }

    @BuildStep
    void watchChanges(QuinoaConfig quinoaConfig, Optional<QuinoaDirectoryBuildItem> quinoaDir, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        if (!quinoaDir.isPresent() || quinoaConfig.devServerPort.isPresent()) {
            return;
        }
        this.scan(quinoaDir.get().getPackageManager().getDirectory(), watchedPaths);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(QuinoaConfig quinoaConfig, Optional<BuiltResourcesBuildItem> uiResources, QuinoaRecorder recorder, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, BuildProducer<DefaultRouteBuildItem> defaultRoutes, BuildProducer<RouteBuildItem> routes, BuildProducer<ResumeOn404BuildItem> resumeOn404) throws IOException {
        if (uiResources.isPresent() && !uiResources.get().getNames().isEmpty()) {
            String directory = null;
            if (uiResources.get().getDirectory().isPresent()) {
                directory = uiResources.get().getDirectory().get().toAbsolutePath().toString();
            }
            List<String> ignoredPathPrefixes = quinoaConfig.getNormalizedIgnoredPathPrefixes();
            boolean enableSPARouting = quinoaConfig.isSPARoutingEnabled();
            resumeOn404.produce((BuildItem)new ResumeOn404BuildItem());
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(1100)).handler(recorder.quinoaHandler(directory, uiResources.get().getNames(), ignoredPathPrefixes)).build());
            if (enableSPARouting) {
                routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(20100)).handler(recorder.quinoaSPARoutingHandler(ignoredPathPrefixes)).build());
            }
        }
    }

    private HashSet<BuiltResourcesBuildItem.BuiltResource> prepareBuiltResources(BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, Path targetDir) throws IOException {
        List files = Files.walk(targetDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        HashSet<BuiltResourcesBuildItem.BuiltResource> entries = new HashSet<BuiltResourcesBuildItem.BuiltResource>(files.size());
        LOG.infof("Quinoa target directory: '%s'", (Object)targetDir);
        for (Path file : files) {
            String name = "/" + targetDir.relativize(file);
            LOG.infof("Quinoa generated resource: '%s'", (Object)name);
            generatedResources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/webui" + name, Files.readAllBytes(file), true));
            if (nativeImageResources != null) {
                nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/webui" + name}));
            }
            entries.add(new BuiltResourcesBuildItem.BuiltResource(name));
        }
        return entries;
    }

    private void scan(Path directory, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    LOG.debugf("Quinoa is watching: %s", (Object)filePath);
                    watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(filePath.toString()));
                    continue;
                }
                if (!Files.isDirectory(filePath, new LinkOption[0]) || IGNORE_WATCH.contains(filePath.getFileName().toString())) continue;
                LOG.debugf("Quinoa is scanning directory: %s", (Object)filePath);
                this.scan(filePath, watchedPaths);
            }
        }
    }

    private AbstractMap.SimpleEntry<Path, Path> computeUIDir(String configuredDir, OutputTargetBuildItem outputTarget) {
        AbstractMap.SimpleEntry<Path, Path> mainSourcesRoot = QuinoaProcessor.findMainSourcesRoot(outputTarget.getOutputDirectory());
        if (mainSourcesRoot == null) {
            return null;
        }
        Path uiRoot = ((Path)mainSourcesRoot.getValue()).resolve(configuredDir);
        File file = uiRoot.toFile();
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        return new AbstractMap.SimpleEntry<Path, Path>(uiRoot, (Path)mainSourcesRoot.getValue());
    }

    static AbstractMap.SimpleEntry<Path, Path> findMainSourcesRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            Path toCheck;
            if ((toCheck = currentPath.resolve(Paths.get("src", "main"))).toFile().exists()) {
                return new AbstractMap.SimpleEntry<Path, Path>(toCheck, currentPath);
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }

    private static boolean isCI() {
        String ci = System.getProperties().containsKey("CI") ? System.getProperty("CI") : System.getenv().getOrDefault("CI", "false");
        return Objects.equals(ci, "true");
    }

    private static class QuinoaLiveContext {
        private final Path location;

        private QuinoaLiveContext(Path location) {
            this.location = location;
        }

        public Path getLocation() {
            return this.location;
        }
    }
}

