/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkus.deployment.util.ProcessUtil;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class PackageManager {
    private static final Logger LOG = Logger.getLogger(PackageManager.class);
    private static final Commands NPM = new NPMCommands();
    private static final Commands YARN = new YarnCommands();
    private static final Commands PNPM = new PNPMCommands();
    private final String packageManagerBinary;
    private final Path directory;
    private final Commands commands;

    private PackageManager(String packageManagerBinary, Path directory) {
        this.packageManagerBinary = packageManagerBinary;
        this.directory = directory;
        this.commands = PackageManager.resolveCommands(packageManagerBinary);
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void install(boolean frozenLockfile) {
        Command install = this.commands.install(frozenLockfile);
        String printable = install.printable(this.packageManagerBinary);
        LOG.infof("Running Quinoa package manager install command: %s", (Object)printable);
        if (!this.exec(install)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager install command: %s", printable));
        }
    }

    public void build(LaunchMode mode) {
        Command build = this.commands.build(mode);
        String printable = build.printable(this.packageManagerBinary);
        LOG.infof("Running Quinoa package manager build command: %s", (Object)printable);
        if (!this.exec(build)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager build command: %s", printable));
        }
    }

    public void test() {
        Command test = this.commands.test();
        String printable = test.printable(this.packageManagerBinary);
        LOG.infof("Running Quinoa package manager test command: %s", (Object)printable);
        if (!this.exec(test)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager test command: %s", printable));
        }
    }

    public void stopDev(Process process) {
        if (process == null) {
            return;
        }
        LOG.infof("Stopping Quinoa package manager live coding as a dev service.", new Object[0]);
        process.descendants().forEach(new Consumer<ProcessHandle>(){

            @Override
            public void accept(ProcessHandle processHandle) {
                processHandle.destroy();
            }
        });
        if (process.isAlive()) {
            process.destroy();
            try {
                if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                    process.destroyForcibly();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Process dev(int checkPort, int timeout) {
        Command dev = this.commands.dev();
        LOG.infof("Running Quinoa package manager live coding as a dev service: %s", (Object)dev.printable(this.packageManagerBinary));
        final Process p = this.process(dev);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PackageManager.this.stopDev(p);
            }
        });
        try {
            int i = 0;
            while (!PackageManager.isDevServerUp(checkPort)) {
                if (++i >= timeout / 500) {
                    this.stopDev(p);
                    throw new RuntimeException("Quinoa package manager live coding port " + checkPort + " is still not listening after the timeout.");
                }
                Thread.sleep(500L);
            }
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.stopDev(p);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return p;
    }

    public static PackageManager autoDetectPackageManager(Optional<String> binary, Path directory) {
        Object resolved = null;
        if (binary.isEmpty()) {
            resolved = Files.isRegularFile(directory.resolve("yarn.lock"), new LinkOption[0]) ? "yarn" : (Files.isRegularFile(directory.resolve("pnpm-lock.yaml"), new LinkOption[0]) ? "pnpm" : "npm");
            String os = System.getProperty("os.name");
            if (os != null && os.startsWith("Windows")) {
                resolved = (String)resolved + ".cmd";
            }
        } else {
            resolved = binary.get();
        }
        return new PackageManager((String)resolved, directory);
    }

    static Commands resolveCommands(String binary) {
        if (binary.contains("pnpm")) {
            return PNPM;
        }
        if (binary.contains("npm")) {
            return NPM;
        }
        if (binary.contains("yarn")) {
            return YARN;
        }
        throw new UnsupportedOperationException("Unsupported package manager binary: " + binary);
    }

    private Process process(Command command) {
        Process process = null;
        String[] cmd = new String[command.args.length + 1];
        cmd[0] = this.packageManagerBinary;
        if (command.args.length > 0) {
            System.arraycopy(command.args, 0, cmd, 1, command.args.length);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(this.directory.toFile()).command(cmd);
        if (!command.envs.isEmpty()) {
            builder.environment().putAll(command.envs);
        }
        try {
            process = ProcessUtil.launchProcess((ProcessBuilder)builder, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while running process.", e);
        }
        return process;
    }

    private boolean exec(Command command) {
        Process process = null;
        try {
            String[] cmd = new String[command.args.length + 1];
            cmd[0] = this.packageManagerBinary;
            if (command.args.length > 0) {
                System.arraycopy(command.args, 0, cmd, 1, command.args.length);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (!command.envs.isEmpty()) {
                processBuilder.environment().putAll(command.envs);
            }
            process = processBuilder.directory(this.directory.toFile()).command(cmd).redirectErrorStream(true).start();
            new HandleOutput(process.getInputStream()).run();
            process.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return process != null && process.exitValue() == 0;
    }

    private static boolean isDevServerUp(int port) {
        try {
            URL url = new URL("http://localhost:" + port);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(200);
            connection.setReadTimeout(200);
            connection.connect();
            int code = connection.getResponseCode();
            return code == 200;
        }
        catch (ConnectException | SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while checking if package manager dev server is up", e);
        }
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Logger.Level logLevel;

        HandleOutput(InputStream is) {
            this(is, Logger.Level.INFO);
        }

        HandleOutput(InputStream is, Logger.Level logLevel) {
            this.is = is;
            this.logLevel = LOG.isEnabled(logLevel) ? logLevel : null;
        }

        @Override
        public void run() {
            block14: {
                try (InputStreamReader isr = new InputStreamReader(this.is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        if (this.logLevel != null) {
                            LOG.log(this.logLevel, (Object)line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (this.logLevel == null) break block14;
                    LOG.log(this.logLevel, (Object)"Failed to handle output", (Throwable)e);
                }
            }
        }
    }

    private static class YarnCommands
    implements Commands {
        private YarnCommands() {
        }

        @Override
        public Command install(boolean frozenLockfile) {
            if (frozenLockfile) {
                return new Command("install", "--frozen-lockfile");
            }
            return new Command("install");
        }
    }

    private static class PNPMCommands
    implements Commands {
        private PNPMCommands() {
        }

        @Override
        public Command install(boolean frozenLockfile) {
            if (frozenLockfile) {
                return new Command("install", "--frozen-lockfile");
            }
            return new Command("install");
        }
    }

    private static class NPMCommands
    implements Commands {
        private NPMCommands() {
        }

        @Override
        public Command install(boolean frozenLockfile) {
            if (frozenLockfile) {
                return new Command("ci");
            }
            return new Command("install");
        }
    }

    static interface Commands {
        public Command install(boolean var1);

        default public Command build(LaunchMode mode) {
            return new Command(Collections.singletonMap("MODE", mode.getDefaultProfile()), "run", "build");
        }

        default public Command test() {
            return new Command(Collections.singletonMap("CI", "true"), "test");
        }

        default public Command dev() {
            return new Command(Collections.singletonMap("BROWSER", "none"), "start");
        }
    }

    private static class Command {
        public final Map<String, String> envs;
        public final String[] args;

        private Command(String ... args) {
            this.envs = Collections.emptyMap();
            this.args = args;
        }

        private Command(Map<String, String> envs, String ... args) {
            this.envs = envs;
            this.args = args;
        }

        public String printable(String binary) {
            return binary + " " + String.join((CharSequence)" ", this.args);
        }
    }
}

