/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class QuinoaConfig {
    private static final String DEFAULT_WEB_UI_DIR = "src/main/webui";
    private static final int DEFAULT_DEV_SERVER_TIMEOUT = 30000;
    private static final String DEFAULT_INDEX_PAGE = "index.html";
    @ConfigItem(name="<<parent>>")
    Optional<Boolean> enable;
    @ConfigItem
    public Optional<String> uiDir;
    @ConfigItem
    public Optional<String> buildDir;
    @ConfigItem
    public Optional<String> packageManager;
    @ConfigItem
    public Optional<String> indexPage;
    @ConfigItem(name="run-tests")
    Optional<Boolean> runTests;
    @ConfigItem
    public Optional<Boolean> frozenLockfile;
    @ConfigItem
    public Optional<Boolean> alwaysInstall;
    @ConfigItem
    public Optional<Boolean> enableSPARouting;
    @ConfigItem
    public Optional<List<String>> ignoredPathPrefixes;
    @ConfigItem
    public OptionalInt devServerPort;
    @ConfigItem
    public OptionalInt devServerTimeout;
    @ConfigItem
    public Optional<Boolean> enableDevServerLogs;

    public List<String> getNormalizedIgnoredPathPrefixes() {
        return this.ignoredPathPrefixes.orElseGet(() -> {
            Config config = ConfigProvider.getConfig();
            ArrayList defaultIgnored = new ArrayList();
            this.readExternalConfigPath(config, "quarkus.resteasy.path").ifPresent(defaultIgnored::add);
            this.readExternalConfigPath(config, "quarkus.rest.path").ifPresent(defaultIgnored::add);
            this.readExternalConfigPath(config, "quarkus.http.non-application-root-path").ifPresent(defaultIgnored::add);
            return defaultIgnored;
        }).stream().map(s -> s.startsWith("/") ? s : "/" + s).collect(Collectors.toList());
    }

    public String getIndexPage() {
        return this.indexPage.orElse(DEFAULT_INDEX_PAGE);
    }

    public QuinoaHandlerConfig toHandlerConfig() {
        return new QuinoaHandlerConfig(this.getNormalizedIgnoredPathPrefixes(), this.getIndexPage());
    }

    private Optional<String> readExternalConfigPath(Config config, String key) {
        return config.getOptionalValue(key, String.class).filter(s -> !Objects.equals(s, "/")).map(s -> s.endsWith("/") ? s : s + "/");
    }

    public String getUIDir() {
        return this.uiDir.orElse(DEFAULT_WEB_UI_DIR);
    }

    public String getBuildDir() {
        return this.buildDir.orElse("build");
    }

    public int getDevServerTimeout() {
        return this.devServerTimeout.orElse(30000);
    }

    public boolean shouldRunTests() {
        return this.runTests.orElse(false);
    }

    public boolean shouldEnableDevServerLogs() {
        return this.enableDevServerLogs.orElse(false);
    }

    public boolean isEnabled() {
        return this.enable.orElse(true);
    }

    public boolean isSPARoutingEnabled() {
        return this.enableSPARouting.orElse(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuinoaConfig that = (QuinoaConfig)o;
        return this.enable.equals(that.enable) && this.uiDir.equals(that.uiDir) && this.buildDir.equals(that.buildDir) && this.packageManager.equals(that.packageManager) && this.runTests.equals(that.runTests) && this.frozenLockfile.equals(that.frozenLockfile) && this.alwaysInstall.equals(that.alwaysInstall) && this.enableSPARouting.equals(that.enableSPARouting) && this.ignoredPathPrefixes.equals(that.ignoredPathPrefixes) && this.devServerPort.equals(that.devServerPort) && this.devServerTimeout.equals(that.devServerTimeout) && this.enableDevServerLogs.equals(that.enableDevServerLogs);
    }

    public int hashCode() {
        return Objects.hash(this.enable, this.uiDir, this.buildDir, this.packageManager, this.runTests, this.frozenLockfile, this.alwaysInstall, this.enableSPARouting, this.ignoredPathPrefixes, this.devServerPort, this.devServerTimeout, this.enableDevServerLogs);
    }
}

