/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.deployment.DevServerConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerInstallConfig;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public class QuinoaConfig {
    private static final String DEFAULT_WEB_UI_DIR = "src/main/webui";
    private static final String DEFAULT_INDEX_PAGE = "index.html";
    @ConfigItem(name="<<parent>>", defaultValueDocumentation="disabled in test mode")
    Optional<Boolean> enable;
    @ConfigItem
    public boolean justBuild;
    @ConfigItem(defaultValue="src/main/webui")
    public String uiDir;
    @ConfigItem(defaultValue="build/")
    public String buildDir;
    @ConfigItem(defaultValueDocumentation="auto-detected with lockfile")
    public Optional<String> packageManager;
    @ConfigItem
    public PackageManagerInstallConfig packageManagerInstall;
    @ConfigItem
    public PackageManagerCommandConfig packageManagerCommand;
    @ConfigItem(defaultValue="index.html")
    public String indexPage;
    @ConfigItem(name="run-tests")
    boolean runTests;
    @ConfigItem(defaultValueDocumentation="true if environment CI=true")
    public Optional<Boolean> frozenLockfile;
    @ConfigItem
    public boolean forceInstall;
    @ConfigItem
    public boolean enableSPARouting;
    @ConfigItem
    public Optional<List<String>> ignoredPathPrefixes;
    @ConfigItem
    public DevServerConfig devServer;

    public boolean isDevServerMode() {
        return this.devServer.enabled && this.devServer.port.isPresent();
    }

    public List<String> getNormalizedIgnoredPathPrefixes() {
        return this.ignoredPathPrefixes.orElseGet(() -> {
            Config config = ConfigProvider.getConfig();
            ArrayList defaultIgnore = new ArrayList();
            this.readExternalConfigPath(config, "quarkus.resteasy.path").ifPresent(defaultIgnore::add);
            this.readExternalConfigPath(config, "quarkus.resteasy-reactive.path").ifPresent(defaultIgnore::add);
            this.readExternalConfigPath(config, "quarkus.http.non-application-root-path").ifPresent(defaultIgnore::add);
            return defaultIgnore;
        }).stream().map(s -> s.startsWith("/") ? s : "/" + s).collect(Collectors.toList());
    }

    public QuinoaHandlerConfig toHandlerConfig(boolean prodMode, HttpBuildTimeConfig httpBuildTimeConfig) {
        Set compressMediaTypes = httpBuildTimeConfig.compressMediaTypes.map(Set::copyOf).orElse(Set.of());
        return new QuinoaHandlerConfig(this.getNormalizedIgnoredPathPrefixes(), this.indexPage, prodMode, httpBuildTimeConfig.enableCompression, compressMediaTypes);
    }

    private Optional<String> readExternalConfigPath(Config config, String key) {
        return config.getOptionalValue(key, String.class).filter(s -> !Objects.equals(s, "/")).map(s -> s.endsWith("/") ? s : s + "/");
    }

    public boolean isEnabled() {
        return this.enable.orElse(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuinoaConfig that = (QuinoaConfig)o;
        return this.runTests == that.runTests && this.forceInstall == that.forceInstall && this.enableSPARouting == that.enableSPARouting && Objects.equals(this.enable, that.enable) && Objects.equals(this.uiDir, that.uiDir) && Objects.equals(this.buildDir, that.buildDir) && Objects.equals(this.packageManager, that.packageManager) && Objects.equals(this.packageManagerInstall, that.packageManagerInstall) && Objects.equals(this.packageManagerCommand, that.packageManagerCommand) && Objects.equals(this.indexPage, that.indexPage) && Objects.equals(this.frozenLockfile, that.frozenLockfile) && Objects.equals(this.ignoredPathPrefixes, that.ignoredPathPrefixes) && Objects.equals(this.devServer, that.devServer);
    }

    public int hashCode() {
        return Objects.hash(this.enable, this.uiDir, this.buildDir, this.packageManager, this.packageManagerInstall, this.packageManagerCommand, this.indexPage, this.runTests, this.frozenLockfile, this.forceInstall, this.enableSPARouting, this.ignoredPathPrefixes, this.devServer);
    }
}

