/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import io.quarkiverse.quinoa.deployment.packagemanager.Command;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManager;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerCommands;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class EffectiveCommands
implements PackageManagerCommands {
    private static final String PATH_ENV_VAR = "PATH";
    private final PackageManagerCommands defaultCommands;
    private final PackageManagerCommandConfig commandsConfig;
    private final List<String> paths;

    EffectiveCommands(PackageManagerCommands defaultCommands, PackageManagerCommandConfig commandsConfig, List<String> paths) {
        this.defaultCommands = defaultCommands;
        this.commandsConfig = commandsConfig;
        this.paths = paths;
    }

    @Override
    public Command install(boolean frozenLockfile) {
        Command c = this.defaultCommands.install(frozenLockfile);
        return new Command(this.environment(c, this.commandsConfig.installEnv), this.getCustomCommandWithArguments(this.commandsConfig.install).orElse(c.commandWithArguments));
    }

    @Override
    public String binary() {
        return this.defaultCommands.binary();
    }

    @Override
    public Command build(LaunchMode mode) {
        Command c = this.defaultCommands.build(mode);
        return new Command(this.environment(c, this.commandsConfig.buildEnv), this.getCustomCommandWithArguments(this.commandsConfig.build).orElse(c.commandWithArguments));
    }

    @Override
    public Command test() {
        Command c = this.defaultCommands.test();
        return new Command(this.environment(c, this.commandsConfig.testEnv), this.getCustomCommandWithArguments(this.commandsConfig.test).orElse(c.commandWithArguments));
    }

    @Override
    public Command dev() {
        Command c = this.defaultCommands.dev();
        return new Command(this.environment(c, this.commandsConfig.devEnv), this.getCustomCommandWithArguments(this.commandsConfig.dev).orElse(c.commandWithArguments));
    }

    private Optional<String> getCustomCommandWithArguments(Optional<String> command) {
        return command.map(a -> this.commandsConfig.prependBinary ? this.defaultCommands.binary() + " " + a : a);
    }

    private Map<String, String> environment(Command c, Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.putAll(c.envs);
        if (additionalEnvironment != null) {
            environment.putAll(additionalEnvironment);
        }
        if (PackageManager.isWindows()) {
            for (Map.Entry entry : environment.entrySet()) {
                String pathName = (String)entry.getKey();
                if (!PATH_ENV_VAR.equalsIgnoreCase(pathName)) continue;
                String pathValue = (String)entry.getValue();
                environment.put(pathName, this.extendPathVariable(pathValue, this.paths));
            }
        } else {
            String pathValue = (String)environment.get(PATH_ENV_VAR);
            environment.put(PATH_ENV_VAR, this.extendPathVariable(pathValue, this.paths));
        }
        return environment;
    }

    private String extendPathVariable(String existingValue, List<String> paths) {
        StringBuilder pathBuilder = new StringBuilder();
        for (String path : paths) {
            pathBuilder.append(path).append(File.pathSeparator);
        }
        if (existingValue != null) {
            pathBuilder.append(existingValue).append(File.pathSeparator);
        }
        return pathBuilder.toString();
    }
}

