/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import io.quarkiverse.quinoa.deployment.QuinoaProcessor;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManager;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerInstallConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.jboss.logging.Logger;

public final class PackageManagerInstall {
    private static final Logger LOG = Logger.getLogger(PackageManagerInstall.class);
    private static final String INSTALL_SUB_PATH = "node";
    public static final String NODE_BINARY = PackageManager.isWindows() ? "node.exe" : "node";
    public static final String NPM_PATH = "node/node_modules/npm/bin/npm-cli.js";

    private PackageManagerInstall() {
    }

    public static Installation install(PackageManagerInstallConfig config, QuinoaProcessor.ProjectDirs projectDirs) {
        Path installDir = PackageManagerInstall.resolveInstallDir(config, projectDirs).normalize();
        FrontendPluginFactory factory = new FrontendPluginFactory(null, installDir.toFile());
        if (!config.nodeVersion.isPresent()) {
            throw new ConfigurationException("node-version is required to install package manager", Set.of("quarkus.quinoa.package-manager-install.node-version"));
        }
        if (Integer.parseInt(config.nodeVersion.get().split("[.]")[0]) < 4) {
            throw new ConfigurationException("Quinoa is not compatible with Node prior to v4.0.0", Set.of("quarkus.quinoa.package-manager-install.node-version"));
        }
        try {
            ProxyConfig proxy = new ProxyConfig(Collections.emptyList());
            try {
                factory.getNodeInstaller(proxy).setNodeVersion("v" + config.nodeVersion.get()).setNodeDownloadRoot(config.nodeDownloadRoot).setNpmVersion(config.npmVersion).install();
            }
            catch (InstallationException e) {
                if (e.getCause() instanceof DirectoryNotEmptyException && e.getCause().getMessage().contains("tmp")) {
                    LOG.warnf("Quinoa was not able to delete the Node install temporary directory: %s", (Object)e.getCause().getMessage());
                }
                throw e;
            }
            factory.getNPMInstaller(proxy).setNodeVersion("v" + config.nodeVersion.get()).setNpmVersion(config.npmVersion).setNpmDownloadRoot(config.npmDownloadRoot).install();
            return PackageManagerInstall.resolveInstalledNpmBinary(installDir);
        }
        catch (InstallationException e) {
            throw new RuntimeException("Error while installing NodeJS", e);
        }
    }

    private static Path resolveInstallDir(PackageManagerInstallConfig config, QuinoaProcessor.ProjectDirs projectDirs) {
        Path installPath = Path.of(config.installDir.trim(), new String[0]);
        if (installPath.isAbsolute()) {
            return installPath;
        }
        if (projectDirs.getProjectRootDir() == null) {
            throw new ConfigurationException("Use an absolute package-manager-install.install-dir when the project root directory is not standard", Set.of("quarkus.quinoa.package-manager-install.install-dir"));
        }
        return projectDirs.getProjectRootDir().resolve(installPath);
    }

    private static Installation resolveInstalledNpmBinary(Path installDirectory) {
        Path nodeDirPath = installDirectory.resolve(INSTALL_SUB_PATH).toAbsolutePath();
        Path npmPath = installDirectory.resolve(NPM_PATH).toAbsolutePath();
        String platformNodeDirPath = PackageManagerInstall.normalizePath(nodeDirPath.toString());
        String platformNPMPath = PackageManagerInstall.normalizePath(npmPath.toString());
        String packageManagerBinary = NODE_BINARY + " " + PackageManagerInstall.quotePathWithSpaces(platformNPMPath);
        return new Installation(platformNodeDirPath, packageManagerBinary);
    }

    public static String normalizePath(String path) {
        return PackageManager.isWindows() ? path.replaceAll("/", "\\\\") : path;
    }

    public static String quotePathWithSpaces(String path) {
        return path.contains(" ") ? "\"".concat(path).concat("\"") : path;
    }

    public static class Installation {
        private final String nodeDirPath;
        private final String packageManagerBinary;

        public Installation(String nodeDirPath, String packageManagerBinary) {
            this.nodeDirPath = nodeDirPath;
            this.packageManagerBinary = packageManagerBinary;
        }

        public String getNodeDirPath() {
            return this.nodeDirPath;
        }

        public String getPackageManagerBinary() {
            return this.packageManagerBinary;
        }
    }
}

