/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import io.quarkiverse.quinoa.deployment.packagemanager.Command;
import io.quarkiverse.quinoa.deployment.packagemanager.EffectiveCommands;
import io.quarkiverse.quinoa.deployment.packagemanager.NPMPackageManagerCommands;
import io.quarkiverse.quinoa.deployment.packagemanager.PNPMPackageManagerCommands;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerCommands;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerType;
import io.quarkiverse.quinoa.deployment.packagemanager.YarnPackageManagerCommands;
import io.quarkus.deployment.util.ProcessUtil;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class PackageManager {
    private static final Logger LOG = Logger.getLogger(PackageManager.class);
    private final Path directory;
    private final PackageManagerCommands packageManagerCommands;

    private PackageManager(Path directory, PackageManagerCommands packageManagerCommands) {
        this.directory = directory;
        this.packageManagerCommands = packageManagerCommands;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void install(boolean frozenLockfile) {
        Command install = this.packageManagerCommands.install(frozenLockfile);
        LOG.infof("Running Quinoa package manager install command: %s", (Object)install.commandWithArguments);
        if (!this.exec(install)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager install command: %s", install.commandWithArguments));
        }
    }

    public void build(LaunchMode mode) {
        Command build = this.packageManagerCommands.build(mode);
        LOG.infof("Running Quinoa package manager build command: %s", (Object)build.commandWithArguments);
        if (!this.exec(build)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager build command: %s", build.commandWithArguments));
        }
    }

    public void test() {
        Command test = this.packageManagerCommands.test();
        LOG.infof("Running Quinoa package manager test command: %s", (Object)test.commandWithArguments);
        if (!this.exec(test)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager test command: %s", test.commandWithArguments));
        }
    }

    public void stopDev(Process process) {
        if (process == null || !process.isAlive()) {
            return;
        }
        LOG.infof("Stopping Quinoa package manager live coding as a dev service.", new Object[0]);
        try {
            PackageManager.killDescendants(process.toHandle(), false);
            if (process.isAlive()) {
                process.destroy();
                PackageManager.killDescendants(process.toHandle(), true);
                if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                    process.destroyForcibly();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.errorf((Throwable)e, "Error while waiting for Quinoa Dev Server process (#%s) to exit.", (Object)process.pid());
        }
        finally {
            if (process.isAlive()) {
                LOG.warnf("Quinoa was not able to stop the Dev Server process (#%s).", (Object)process.pid());
            }
        }
    }

    private static void killDescendants(ProcessHandle process, boolean force) {
        process.children().forEach(child -> {
            PackageManager.killDescendants(child, force);
            if (child.isAlive()) {
                if (force) {
                    child.destroyForcibly();
                } else {
                    child.destroy();
                }
            }
        });
    }

    public Process dev(String devServerHost, int devServerPort, String checkPath, int checkTimeout) {
        Command dev = this.packageManagerCommands.dev();
        LOG.infof("Running Quinoa package manager live coding as a dev service: %s", (Object)dev.commandWithArguments);
        final Process p = this.process(dev);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PackageManager.this.stopDev(p);
            }
        });
        if (checkPath == null) {
            LOG.infof("Quinoa is configured to continue without check if the live coding server is up", new Object[0]);
            return p;
        }
        try {
            int i = 0;
            while (!PackageManager.isDevServerUp(devServerHost, devServerPort, checkPath)) {
                if (++i >= checkTimeout / 500) {
                    this.stopDev(p);
                    throw new RuntimeException("Quinoa package manager live coding port " + devServerPort + " is still not listening after the checkTimeout.");
                }
                Thread.sleep(500L);
            }
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.stopDev(p);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return p;
    }

    public static PackageManager autoDetectPackageManager(Optional<String> binary, PackageManagerCommandConfig packageManagerCommands, Path directory, List<String> paths) {
        Object resolved = null;
        if (binary.isEmpty()) {
            resolved = Files.isRegularFile(directory.resolve(PackageManagerType.YARN.getLockFile()), new LinkOption[0]) ? PackageManagerType.YARN.getCommand() : (Files.isRegularFile(directory.resolve(PackageManagerType.PNPM.getLockFile()), new LinkOption[0]) ? PackageManagerType.PNPM.getCommand() : PackageManagerType.NPM.getCommand());
            if (PackageManager.isWindows()) {
                resolved = (String)resolved + ".cmd";
            }
        } else {
            resolved = binary.get();
        }
        return new PackageManager(directory, PackageManager.resolveCommands((String)resolved, packageManagerCommands, paths));
    }

    public static boolean isWindows() {
        return QuarkusConsole.IS_WINDOWS;
    }

    static PackageManagerCommands resolveCommands(String binary, PackageManagerCommandConfig packageManagerCommands, List<String> paths) {
        if (binary.contains(PackageManagerType.PNPM.getCommand())) {
            return new EffectiveCommands(new PNPMPackageManagerCommands(binary), packageManagerCommands, paths);
        }
        if (binary.contains(PackageManagerType.NPM.getCommand())) {
            return new EffectiveCommands(new NPMPackageManagerCommands(binary), packageManagerCommands, paths);
        }
        if (binary.contains(PackageManagerType.YARN.getCommand())) {
            return new EffectiveCommands(new YarnPackageManagerCommands(binary), packageManagerCommands, paths);
        }
        throw new UnsupportedOperationException("Unsupported package manager binary: " + binary);
    }

    private Process process(Command command) {
        Process process = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(this.directory.toFile()).command(this.runner(command));
        if (!command.envs.isEmpty()) {
            builder.environment().putAll(command.envs);
        }
        try {
            process = ProcessUtil.launchProcess((ProcessBuilder)builder, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while running process.", e);
        }
        return process;
    }

    private boolean exec(Command command) {
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (!command.envs.isEmpty()) {
                processBuilder.environment().putAll(command.envs);
            }
            process = processBuilder.directory(this.directory.toFile()).command(this.runner(command)).redirectErrorStream(true).start();
            new HandleOutput(process.getInputStream()).run();
            process.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return process != null && process.exitValue() == 0;
    }

    private String[] runner(Command command) {
        if (PackageManager.isWindows()) {
            return new String[]{"cmd.exe", "/c", command.commandWithArguments};
        }
        return new String[]{"sh", "-c", command.commandWithArguments};
    }

    public static boolean isDevServerUp(String host, int port, String path) {
        try {
            Object normalizedPath = path.indexOf("/") == 0 ? path : "/" + path;
            URL url = new URL(String.format("http://%s:%d%s", host, port, normalizedPath));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(200);
            connection.setReadTimeout(200);
            connection.connect();
            int code = connection.getResponseCode();
            return code == 200;
        }
        catch (ConnectException | SocketTimeoutException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while checking if package manager dev server is up", e);
        }
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Logger.Level logLevel;

        HandleOutput(InputStream is) {
            this(is, Logger.Level.INFO);
        }

        HandleOutput(InputStream is, Logger.Level logLevel) {
            this.is = is;
            this.logLevel = LOG.isEnabled(logLevel) ? logLevel : null;
        }

        @Override
        public void run() {
            block14: {
                try (InputStreamReader isr = new InputStreamReader(this.is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        if (this.logLevel != null) {
                            LOG.log(this.logLevel, (Object)line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (this.logLevel == null) break block14;
                    LOG.log(this.logLevel, (Object)"Failed to handle output", (Throwable)e);
                }
            }
        }
    }
}

