/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.deployment.DevServerConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManager;
import io.quarkus.builder.item.SimpleBuildItem;
import java.nio.file.Path;
import java.util.Objects;
import java.util.OptionalInt;

public final class QuinoaDirectoryBuildItem
extends SimpleBuildItem {
    private final PackageManager packageManager;
    private final OptionalInt devServerPort;
    private final String devServerCommand;
    private final String buildDirectory;

    public QuinoaDirectoryBuildItem(PackageManager packageManager, String devServerCommand, OptionalInt devServerPort, String buildDirectory) {
        this.packageManager = packageManager;
        this.devServerPort = devServerPort;
        this.buildDirectory = buildDirectory;
        this.devServerCommand = Objects.toString(devServerCommand, "start");
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public Path getDirectory() {
        return this.getPackageManager().getDirectory();
    }

    public OptionalInt getDevServerPort() {
        return this.devServerPort;
    }

    public String getDevServerCommand() {
        return this.devServerCommand;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public boolean isDevServerMode(DevServerConfig devServerConfig) {
        return devServerConfig.enabled && this.devServerPort.isPresent();
    }
}

