/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import io.quarkiverse.quinoa.deployment.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.DetectedFramework;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public enum FrameworkType {
    REACT("build", "start", 3000, Set.of("react-scripts", "react-app-rewired", "craco")),
    VITE("dist", "dev", 5173, Set.of("vite")),
    NEXT("out", "dev", 3000, Set.of("next")),
    ANGULAR("dist/%s", "start", 4200, Set.of("ng")),
    WEB_COMPONENTS("dist", "start", 8003, Set.of("web-dev-server"));

    private static final Logger LOG;
    public static final Set<String> DEV_SCRIPTS;
    private final String buildDirectory;
    private final String devScript;
    private final int devServerPort;
    private final Set<String> packageScripts;

    private FrameworkType(String buildDirectory, String devScript, int devServerPort, Set<String> packageScripts) {
        this.buildDirectory = buildDirectory;
        this.devScript = devScript;
        this.devServerPort = devServerPort;
        this.packageScripts = packageScripts;
    }

    public static DetectedFramework detectFramework(LaunchModeBuildItem launchMode, QuinoaConfig config, Path packageJsonFile) {
        String startCommand;
        JsonString startScript;
        JsonObject packageJson;
        block13: {
            if (config.devServer.port.isPresent() && !"build/".equalsIgnoreCase(config.buildDir)) {
                return new DetectedFramework();
            }
            packageJson = null;
            startScript = null;
            startCommand = null;
            try (JsonReader reader = Json.createReader((InputStream)Files.newInputStream(packageJsonFile, new OpenOption[0]));){
                packageJson = reader.readObject();
                JsonObject scripts = packageJson.getJsonObject("scripts");
                if (scripts == null) break block13;
                for (String devScript : DEV_SCRIPTS) {
                    startScript = scripts.getJsonString(devScript);
                    if (startScript == null) continue;
                    startCommand = devScript;
                    break;
                }
            }
            catch (IOException e) {
                LOG.warnf("Quinoa failed to auto-detect the framework from package.json file. %s", (Object)e.getMessage());
            }
        }
        if (startScript == null || startCommand == null) {
            LOG.info((Object)"Quinoa could not auto-detect the framework from package.json file.");
            return new DetectedFramework();
        }
        FrameworkType frameworkType = FrameworkType.evaluate(startScript.getString());
        if (frameworkType == null) {
            LOG.info((Object)"Quinoa could not auto-detect the framework from package.json file.");
            return new DetectedFramework();
        }
        String expectedCommand = frameworkType.getDevScript();
        if (!Objects.equals(startCommand, expectedCommand)) {
            LOG.warnf("%s framework typically defines a '%s` script in package.json file but found '%s' instead.", (Object)frameworkType, (Object)expectedCommand, startCommand);
        }
        LOG.infof("%s framework automatically detected from package.json file.", (Object)frameworkType);
        return new DetectedFramework(frameworkType, packageJson, startCommand);
    }

    private static FrameworkType evaluate(String script) {
        String lowerScript = script.toLowerCase(Locale.ROOT);
        for (FrameworkType value : FrameworkType.values()) {
            Set<String> commands = value.getPackageScripts();
            for (String command : commands) {
                if (!lowerScript.startsWith(command)) continue;
                return value;
            }
        }
        return null;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getDevScript() {
        return this.devScript;
    }

    public Set<String> getPackageScripts() {
        return this.packageScripts;
    }

    public int getDevServerPort() {
        return this.devServerPort;
    }

    static {
        LOG = Logger.getLogger(FrameworkType.class);
        DEV_SCRIPTS = Arrays.stream(FrameworkType.values()).map(FrameworkType::getDevScript).collect(Collectors.toCollection(TreeSet::new));
    }
}

