/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.QuinoaRecorder;
import io.quarkiverse.quinoa.deployment.BuiltResourcesBuildItem;
import io.quarkiverse.quinoa.deployment.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.QuinoaDirectoryBuildItem;
import io.quarkiverse.quinoa.deployment.TargetDirBuildItem;
import io.quarkiverse.quinoa.deployment.packagemanager.DetectedFramework;
import io.quarkiverse.quinoa.deployment.packagemanager.FrameworkType;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManager;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerInstall;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerType;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.resteasy.reactive.server.spi.ResumeOn404BuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class QuinoaProcessor {
    private static final Logger LOG = Logger.getLogger(QuinoaProcessor.class);
    private static final String FEATURE = "quinoa";
    private static final String TARGET_DIR_NAME = "quinoa-build";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public QuinoaDirectoryBuildItem prepareQuinoaDirectory(LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload, QuinoaConfig quinoaConfig, OutputTargetBuildItem outputTarget) {
        boolean packageFileModified;
        if (!quinoaConfig.isEnabled()) {
            LOG.info((Object)"Quinoa is disabled.");
            return null;
        }
        if (launchMode.isTest() && quinoaConfig.enable.isEmpty()) {
            LOG.warn((Object)"Quinoa is disabled by default in tests.");
            return null;
        }
        String configuredDir = quinoaConfig.uiDir;
        ProjectDirs projectDirs = QuinoaProcessor.resolveProjectDirs(quinoaConfig, outputTarget);
        if (projectDirs == null) {
            return null;
        }
        Path packageJsonFile = projectDirs.uiDir.resolve("package.json");
        if (!Files.isRegularFile(packageJsonFile, new LinkOption[0])) {
            throw new ConfigurationException("No package.json found in Web UI directory: '" + configuredDir + "'");
        }
        Optional<String> packageManagerBinary = quinoaConfig.packageManager;
        ArrayList<String> paths = new ArrayList<String>();
        if (quinoaConfig.packageManagerInstall.enabled) {
            PackageManagerInstall.Installation result = PackageManagerInstall.install(quinoaConfig.packageManagerInstall, projectDirs);
            packageManagerBinary = Optional.of(result.getPackageManagerBinary());
            paths.add(result.getNodeDirPath());
        }
        PackageManager packageManager = PackageManager.autoDetectPackageManager(packageManagerBinary, quinoaConfig.packageManagerCommand, projectDirs.getUIDir(), paths);
        boolean alreadyInstalled = Files.isDirectory(packageManager.getDirectory().resolve("node_modules"), new LinkOption[0]);
        boolean bl = packageFileModified = liveReload.isLiveReload() && liveReload.getChangedResources().stream().anyMatch(r -> r.equals(packageJsonFile.toString()));
        if (quinoaConfig.forceInstall || !alreadyInstalled || packageFileModified) {
            boolean frozenLockfile = quinoaConfig.frozenLockfile.orElseGet(QuinoaProcessor::isCI);
            packageManager.install(frozenLockfile);
        }
        DetectedFramework detectedFramework = FrameworkType.detectFramework(launchMode, quinoaConfig, packageJsonFile);
        return this.initDefaultConfig(packageManager, launchMode, quinoaConfig, detectedFramework);
    }

    @BuildStep
    public TargetDirBuildItem processBuild(QuinoaConfig quinoaConfig, Optional<QuinoaDirectoryBuildItem> quinoaDir, OutputTargetBuildItem outputTarget, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload) throws IOException {
        if (quinoaDir.isEmpty()) {
            return null;
        }
        QuinoaDirectoryBuildItem quinoaDirectoryBuildItem = quinoaDir.get();
        PackageManager packageManager = quinoaDirectoryBuildItem.getPackageManager();
        QuinoaLiveContext contextObject = (QuinoaLiveContext)liveReload.getContextObject(QuinoaLiveContext.class);
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT && quinoaDirectoryBuildItem.isDevServerMode(quinoaConfig.devServer)) {
            return null;
        }
        if (liveReload.isLiveReload() && liveReload.getChangedResources().stream().noneMatch(r -> r.startsWith(packageManager.getDirectory().toString())) && contextObject != null) {
            return new TargetDirBuildItem(contextObject.getLocation());
        }
        if (quinoaConfig.runTests) {
            packageManager.test();
        }
        packageManager.build(launchMode.getLaunchMode());
        String configuredBuildDir = quinoaDirectoryBuildItem.getBuildDirectory();
        Path buildDir = packageManager.getDirectory().resolve(configuredBuildDir);
        if (!Files.isDirectory(buildDir, new LinkOption[0])) {
            throw new ConfigurationException("Quinoa build directory not found: '" + buildDir.toAbsolutePath() + "'", Set.of("quarkus.quinoa.build-dir"));
        }
        Path targetBuildDir = outputTarget.getOutputDirectory().resolve(TARGET_DIR_NAME);
        FileUtil.deleteDirectory((Path)targetBuildDir);
        Files.move(buildDir, targetBuildDir, new CopyOption[0]);
        liveReload.setContextObject(QuinoaLiveContext.class, (Object)new QuinoaLiveContext(targetBuildDir));
        return new TargetDirBuildItem(targetBuildDir);
    }

    @BuildStep(onlyIf={IsNormal.class})
    public BuiltResourcesBuildItem prepareResourcesForNormalMode(Optional<TargetDirBuildItem> targetDir, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResources) throws IOException {
        if (targetDir.isEmpty()) {
            return null;
        }
        return new BuiltResourcesBuildItem(this.prepareBuiltResources(generatedResources, nativeImageResources, targetDir.get().getBuildDirectory()));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public BuiltResourcesBuildItem prepareResourcesForOtherMode(Optional<TargetDirBuildItem> targetDir, BuildProducer<GeneratedResourceBuildItem> generatedResources) throws IOException {
        if (targetDir.isEmpty()) {
            return null;
        }
        HashSet<BuiltResourcesBuildItem.BuiltResource> entries = this.prepareBuiltResources(generatedResources, null, targetDir.get().getBuildDirectory());
        return new BuiltResourcesBuildItem(targetDir.get().getBuildDirectory(), entries);
    }

    @BuildStep
    void watchChanges(QuinoaConfig quinoaConfig, Optional<QuinoaDirectoryBuildItem> quinoaDir, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        if (quinoaDir.isEmpty() || quinoaDir.get().isDevServerMode(quinoaConfig.devServer)) {
            return;
        }
        this.scan(quinoaDir.get().getPackageManager().getDirectory(), watchedPaths);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(QuinoaConfig quinoaConfig, HttpBuildTimeConfig httpBuildTimeConfig, LaunchModeBuildItem launchMode, Optional<BuiltResourcesBuildItem> uiResources, QuinoaRecorder recorder, BuildProducer<RouteBuildItem> routes, BuildProducer<ResumeOn404BuildItem> resumeOn404) throws IOException {
        if (quinoaConfig.justBuild) {
            LOG.info((Object)"Quinoa is in build only mode");
            return;
        }
        if (uiResources.isPresent() && !uiResources.get().getNames().isEmpty()) {
            String directory = null;
            if (uiResources.get().getDirectory().isPresent()) {
                directory = uiResources.get().getDirectory().get().toAbsolutePath().toString();
            }
            QuinoaHandlerConfig handlerConfig = quinoaConfig.toHandlerConfig(!launchMode.getLaunchMode().isDevOrTest(), httpBuildTimeConfig);
            resumeOn404.produce((BuildItem)new ResumeOn404BuildItem());
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(1100)).handler(recorder.quinoaHandler(handlerConfig, directory, uiResources.get().getNames())).build());
            if (quinoaConfig.enableSPARouting) {
                routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", Integer.valueOf(40000)).handler(recorder.quinoaSPARoutingHandler(handlerConfig)).build());
            }
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    List<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles(QuinoaConfig quinoaConfig, OutputTargetBuildItem outputTarget) {
        ArrayList<HotDeploymentWatchedFileBuildItem> watchedFiles = new ArrayList<HotDeploymentWatchedFileBuildItem>(PackageManagerType.values().length);
        ProjectDirs projectDirs = QuinoaProcessor.resolveProjectDirs(quinoaConfig, outputTarget);
        if (projectDirs == null) {
            return watchedFiles;
        }
        for (PackageManagerType pm : PackageManagerType.values()) {
            String watchFile = projectDirs.uiDir.resolve(pm.getLockFile()).toString();
            watchedFiles.add(new HotDeploymentWatchedFileBuildItem(watchFile));
        }
        return watchedFiles;
    }

    private QuinoaDirectoryBuildItem initDefaultConfig(PackageManager packageManager, LaunchModeBuildItem launchMode, QuinoaConfig config, DetectedFramework detectedFramework) {
        String buildDirectory = config.buildDir;
        OptionalInt port = config.devServer.port;
        if (detectedFramework == null || detectedFramework.getFrameworkType() == null) {
            return new QuinoaDirectoryBuildItem(packageManager, "start", port, buildDirectory);
        }
        LOG.infof("%s", (Object)packageManager.getPackageManagerCommands());
        FrameworkType framework = detectedFramework.getFrameworkType();
        if (config.devServer.enabled && launchMode.getLaunchMode() != LaunchMode.NORMAL && port.isEmpty()) {
            LOG.infof("%s framework setting dev server port: %d", (Object)framework, (Object)framework.getDevServerPort());
            port = OptionalInt.of(framework.getDevServerPort());
            LOG.infof("%s framework setting dev script: '%s'", (Object)framework, (Object)detectedFramework.getDevServerCommand());
        }
        if ("build/".equalsIgnoreCase(buildDirectory)) {
            buildDirectory = detectedFramework.getBuildDirectory();
            LOG.infof("%s framework setting build directory: '%s'", (Object)framework, (Object)buildDirectory);
        }
        return new QuinoaDirectoryBuildItem(packageManager, detectedFramework.getDevServerCommand(), port, buildDirectory);
    }

    private HashSet<BuiltResourcesBuildItem.BuiltResource> prepareBuiltResources(BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, Path targetDir) throws IOException {
        List files = Files.walk(targetDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        HashSet<BuiltResourcesBuildItem.BuiltResource> entries = new HashSet<BuiltResourcesBuildItem.BuiltResource>(files.size());
        LOG.infof("Quinoa target directory: '%s'", (Object)targetDir);
        for (Path file : files) {
            String name = "/" + targetDir.relativize(file).toString().replace('\\', '/');
            LOG.infof("Quinoa generated resource: '%s'", (Object)name);
            generatedResources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/webui" + name, Files.readAllBytes(file), true));
            if (nativeImageResources != null) {
                nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/webui" + name}));
            }
            entries.add(new BuiltResourcesBuildItem.BuiltResource(name));
        }
        return entries;
    }

    private void scan(Path directory, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    LOG.debugf("Quinoa is watching: %s", (Object)filePath);
                    watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(filePath.toString()));
                    continue;
                }
                if (!FrameworkType.shouldScanPath(filePath)) continue;
                LOG.debugf("Quinoa is scanning directory: %s", (Object)filePath);
                this.scan(filePath, watchedPaths);
            }
        }
    }

    private static ProjectDirs resolveProjectDirs(QuinoaConfig config, OutputTargetBuildItem outputTarget) {
        Path projectRoot = QuinoaProcessor.findProjectRoot(outputTarget.getOutputDirectory());
        Path configuredUIDirPath = Path.of(config.uiDir.trim(), new String[0]);
        if (projectRoot == null || !Files.isDirectory(projectRoot, new LinkOption[0])) {
            if (configuredUIDirPath.isAbsolute() && Files.isDirectory(configuredUIDirPath, new LinkOption[0])) {
                return new ProjectDirs(null, configuredUIDirPath.normalize());
            }
            throw new IllegalStateException("If not absolute, the Web UI directory is resolved relative to the project root, but Quinoa was not able to find the project root.");
        }
        Path uiRoot = projectRoot.resolve(configuredUIDirPath).normalize();
        if (!Files.isDirectory(uiRoot, new LinkOption[0])) {
            LOG.warnf("Quinoa directory not found 'quarkus.quinoa.ui-dir=%s' resolved to '%s'. It is recommended to remove the quarkus-quinoa extension if not used.", (Object)config.uiDir, (Object)uiRoot.toAbsolutePath());
            return null;
        }
        return new ProjectDirs(projectRoot, uiRoot);
    }

    static Path findProjectRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            if (Files.exists(currentPath.resolve(Paths.get("src", "main")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.properties")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yaml")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yml")), new LinkOption[0])) {
                return currentPath.normalize();
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }

    private static boolean isCI() {
        String ci = System.getProperties().containsKey("CI") ? System.getProperty("CI") : System.getenv().getOrDefault("CI", "false");
        return Objects.equals(ci, "true");
    }

    public static class ProjectDirs {
        private final Path projectRootDir;
        private final Path uiDir;

        public ProjectDirs(Path projectRootDir, Path uiDir) {
            this.projectRootDir = projectRootDir;
            this.uiDir = uiDir;
        }

        public Path getProjectRootDir() {
            return this.projectRootDir;
        }

        public Path getUIDir() {
            return this.uiDir;
        }
    }

    private static class QuinoaLiveContext {
        private final Path location;

        private QuinoaLiveContext(Path location) {
            this.location = location;
        }

        public Path getLocation() {
            return this.location;
        }
    }
}

