/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import io.quarkiverse.quinoa.deployment.packagemanager.FrameworkType;
import jakarta.json.JsonObject;
import java.util.Objects;

public class DetectedFramework {
    private FrameworkType frameworkType;
    private JsonObject packageJson;
    private String devServerCommand;

    public DetectedFramework() {
    }

    public DetectedFramework(FrameworkType frameworkType, JsonObject packageJson, String devServerCommand) {
        this.frameworkType = frameworkType;
        this.packageJson = packageJson;
        this.devServerCommand = devServerCommand;
    }

    public FrameworkType getFrameworkType() {
        return this.frameworkType;
    }

    public void setFrameworkType(FrameworkType frameworkType) {
        this.frameworkType = frameworkType;
    }

    public JsonObject getPackageJson() {
        return this.packageJson;
    }

    public void setPackageJson(JsonObject packageJson) {
        this.packageJson = packageJson;
    }

    public String getDevServerCommand() {
        return this.devServerCommand;
    }

    public void setDevServerCommand(String devServerCommand) {
        this.devServerCommand = devServerCommand;
    }

    public String getBuildDirectory() {
        FrameworkType framework = this.getFrameworkType();
        if (framework == null) {
            return null;
        }
        String buildDirectory = framework.getBuildDirectory();
        if (framework == FrameworkType.ANGULAR) {
            String applicationName = Objects.toString(this.packageJson.getString("name"), "quinoa");
            buildDirectory = String.format(buildDirectory, applicationName);
        }
        return buildDirectory;
    }

    public String toString() {
        return "DetectedFramework{frameworkType=" + this.frameworkType + ", packageJson=" + this.packageJson + ", devServerCommand=" + this.devServerCommand + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectedFramework that = (DetectedFramework)o;
        return this.frameworkType == that.frameworkType && this.packageJson.equals(that.packageJson) && this.devServerCommand.equals(that.devServerCommand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.frameworkType, this.packageJson, this.devServerCommand});
    }
}

