/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DefaultInstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.DirectoryCacheResolver;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import com.github.eirslett.maven.plugins.frontend.lib.PnpmInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.VertxFileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.YarnInstaller;
import io.vertx.core.Vertx;
import java.nio.file.Path;

public class PackageManagerInstallFactory {
    private static final Platform defaultPlatform = Platform.guess();
    private static final String DEFAULT_CACHE_PATH = "cache";
    private final Vertx vertx;
    private final Path uiDir;
    private final Path installDir;
    private final CacheResolver cacheResolver;
    private final VertxFileDownloader fileDownloader;

    public PackageManagerInstallFactory(Vertx vertx, Path uiDir, Path installDir) {
        this.vertx = vertx;
        this.uiDir = uiDir;
        this.installDir = installDir;
        this.cacheResolver = PackageManagerInstallFactory.getDefaultCacheResolver(installDir);
        this.fileDownloader = new VertxFileDownloader(vertx);
    }

    public NodeInstaller getNodeInstaller() {
        return new NodeInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
    }

    public NPMInstaller getNPMInstaller() {
        return new NPMInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
    }

    public PnpmInstaller getPnpmInstaller() {
        return new PnpmInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
    }

    public YarnInstaller getYarnInstaller() {
        return new YarnInstaller(this.getInstallConfig(), (ArchiveExtractor)new DefaultArchiveExtractor(), (FileDownloader)this.fileDownloader);
    }

    private NodeExecutorConfig getExecutorConfig() {
        return new InstallNodeExecutorConfig(this.getInstallConfig());
    }

    private InstallConfig getInstallConfig() {
        return new DefaultInstallConfig(this.installDir.toFile(), this.uiDir.toFile(), this.cacheResolver, defaultPlatform);
    }

    private static final CacheResolver getDefaultCacheResolver(Path root) {
        return new DirectoryCacheResolver(root.resolve(DEFAULT_CACHE_PATH).toFile());
    }
}

