/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.config;

import io.quarkiverse.quinoa.QuinoaHandlerConfig;
import io.quarkiverse.quinoa.deployment.config.DevServerConfig;
import io.quarkiverse.quinoa.deployment.config.FrameworkConfig;
import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.config.PackageManagerInstallConfig;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConfigMapping(prefix="quarkus.quinoa")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface QuinoaConfig {
    public static final String DEFAULT_BUILD_DIR = "build/";
    public static final String DEFAULT_WEB_UI_DIR = "src/main/webui";
    public static final String DEFAULT_INDEX_PAGE = "index.html";

    @WithParentName
    public Optional<Boolean> enabled();

    @WithDefault(value="false")
    public boolean justBuild();

    @WithDefault(value="src/main/webui")
    public String uiDir();

    public Optional<String> buildDir();

    public Optional<String> packageManager();

    public PackageManagerInstallConfig packageManagerInstall();

    public PackageManagerCommandConfig packageManagerCommand();

    @WithDefault(value="index.html")
    public String indexPage();

    @WithDefault(value="false")
    public boolean runTests();

    public Optional<Boolean> ci();

    @WithDefault(value="false")
    public boolean forceInstall();

    public FrameworkConfig framework();

    @WithDefault(value="false")
    @WithName(value="enable-spa-routing")
    public boolean enableSPARouting();

    public Optional<List<String>> ignoredPathPrefixes();

    public DevServerConfig devServer();

    public static List<String> getNormalizedIgnoredPathPrefixes(QuinoaConfig config) {
        return config.ignoredPathPrefixes().orElseGet(() -> {
            Config allConfig = ConfigProvider.getConfig();
            ArrayList defaultIgnore = new ArrayList();
            QuinoaConfig.readExternalConfigPath(allConfig, "quarkus.resteasy.path").ifPresent(defaultIgnore::add);
            QuinoaConfig.readExternalConfigPath(allConfig, "quarkus.resteasy-reactive.path").ifPresent(defaultIgnore::add);
            QuinoaConfig.readExternalConfigPath(allConfig, "quarkus.http.non-application-root-path").ifPresent(defaultIgnore::add);
            return defaultIgnore;
        }).stream().map(s -> s.startsWith("/") ? s : "/" + s).collect(Collectors.toList());
    }

    public static QuinoaHandlerConfig toHandlerConfig(QuinoaConfig config, boolean prodMode, HttpBuildTimeConfig httpBuildTimeConfig) {
        Set compressMediaTypes = httpBuildTimeConfig.compressMediaTypes.map(Set::copyOf).orElse(Set.of());
        String indexPage = !QuinoaConfig.isDevServerMode(config) ? config.indexPage() : config.devServer().indexPage().orElse(config.indexPage());
        return new QuinoaHandlerConfig(QuinoaConfig.getNormalizedIgnoredPathPrefixes(config), indexPage, prodMode, httpBuildTimeConfig.enableCompression, compressMediaTypes);
    }

    private static Optional<String> readExternalConfigPath(Config config, String key) {
        return config.getOptionalValue(key, String.class).filter(s -> !Objects.equals(s, "/")).map(s -> s.endsWith("/") ? s : s + "/");
    }

    public static boolean isDevServerMode(QuinoaConfig config) {
        return config.devServer().enabled() && config.devServer().port().isPresent();
    }

    public static boolean isEnabled(QuinoaConfig config) {
        return config.enabled().orElse(true);
    }
}

