/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import io.vertx.ext.web.codec.BodyCodec;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.jboss.logging.Logger;

public class VertxFileDownloader
implements FileDownloader {
    private static final Logger LOG = Logger.getLogger(VertxFileDownloader.class);
    private final Vertx vertx;
    private WebClient webClient;

    public VertxFileDownloader(Vertx vertx) {
        this.vertx = vertx;
        this.webClient = WebClient.create((Vertx)vertx, (WebClientOptions)new WebClientOptions().setSsl(true).setFollowRedirects(true).setTrustAll(true).setKeepAlive(true));
    }

    public void download(String downloadUrl, String destination, String userName, String password) throws DownloadException {
        System.setProperty("https.protocols", "TLSv1.2");
        String fixedDownloadUrl = downloadUrl;
        try {
            fixedDownloadUrl = FilenameUtils.separatorsToUnix((String)fixedDownloadUrl);
            URI downloadURI = new URI(fixedDownloadUrl);
            Path destinationPath = Path.of(destination, new String[0]);
            if ("file".equalsIgnoreCase(downloadURI.getScheme())) {
                Files.copy(Paths.get(downloadURI), destinationPath, new CopyOption[0]);
            } else {
                CountDownLatch latch = new CountDownLatch(1);
                Files.deleteIfExists(destinationPath);
                AsyncFile destinationFile = this.vertx.fileSystem().openBlocking(destination, new OpenOptions());
                Future future = this.webClient.getAbs(downloadUrl).expect(ResponsePredicate.SC_SUCCESS).as(BodyCodec.pipe((WriteStream)destinationFile)).send();
                future.onComplete(r -> latch.countDown());
                latch.await(5L, TimeUnit.MINUTES);
                if (!future.succeeded()) {
                    throw new DownloadException("Could not download " + downloadUrl, future.cause());
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new DownloadException("Could not download " + downloadUrl, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

