/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.framework.override;

import io.quarkiverse.quinoa.deployment.config.DevServerConfig;
import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.config.delegate.DevServerConfigDelegate;
import io.quarkiverse.quinoa.deployment.config.delegate.QuinoaConfigDelegate;
import io.quarkiverse.quinoa.deployment.framework.override.GenericFramework;
import jakarta.json.JsonObject;
import java.util.Optional;
import org.jboss.logging.Logger;

public class NextFramework
extends GenericFramework {
    private static final Logger LOG = Logger.getLogger(NextFramework.class);

    public NextFramework() {
        super("out", "dev", 3000);
    }

    @Override
    public QuinoaConfig override(QuinoaConfig delegate, Optional<JsonObject> packageJson, Optional<String> detectedDevScript, boolean isCustomized) {
        JsonObject scripts;
        if (delegate.packageManagerCommand().build().equals("run build") && packageJson.isPresent() && (scripts = packageJson.get().getJsonObject("scripts")) != null) {
            String output;
            String buildScript = scripts.getString("build");
            if (buildScript == null || buildScript.isEmpty()) {
                LOG.warn((Object)"Make sure you define  \"build\": \"next build \", in the package.json to make Next work with Quinoa.");
            }
            if (!"export".equals(output = packageJson.get().getString("output"))) {
                LOG.warn((Object)"Make sure you define  \"output\": \"export \", in the package.json to make Next work with Quinoa.");
            }
        }
        return new QuinoaConfigDelegate(super.override(delegate, packageJson, detectedDevScript, isCustomized)){

            @Override
            public DevServerConfig devServer() {
                return new DevServerConfigDelegate(super.devServer()){

                    @Override
                    public Optional<String> indexPage() {
                        return Optional.of(super.indexPage().orElse("/"));
                    }
                };
            }
        };
    }
}

