/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.PackageManagerInstallFactory;
import io.quarkiverse.quinoa.deployment.config.PackageManagerInstallConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerRunner;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManagerType;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

public final class PackageManagerInstall {
    private static final Logger LOG = Logger.getLogger(PackageManagerInstall.class);
    private static final String INSTALL_SUB_PATH = "node";
    public static final String NODE_BINARY = PackageManagerRunner.isWindows() ? "node.exe" : "node";
    public static final String NPM_PATH = "node/node_modules/npm/bin/npm-cli.js";
    public static final String PNPM_PATH = "node/node_modules/corepack/dist/pnpm.js";
    public static final String YARN_PATH = "node/node_modules/corepack/dist/yarn.js";

    private PackageManagerInstall() {
    }

    /*
     * Exception decompiling
     */
    public static Installation install(PackageManagerInstallConfig config, Path projectDir, Path uiDir) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Vertx createVertxInstance() {
        Vertx vertx;
        String originalValue = System.getProperty("vertx.disableDnsResolver");
        try {
            System.setProperty("vertx.disableDnsResolver", "true");
            vertx = Vertx.vertx((VertxOptions)new VertxOptions());
        }
        finally {
            if (originalValue == null) {
                System.clearProperty("vertx.disableDnsResolver");
            } else {
                System.setProperty("vertx.disableDnsResolver", originalValue);
            }
        }
        return vertx;
    }

    private static Installation attemptInstall(PackageManagerInstallConfig config, Path uiDir, Path installDir, PackageManagerInstallFactory factory) throws InstallationException {
        Optional<String> pnpmVersion;
        Optional<String> yarnVersion;
        try {
            factory.getNodeInstaller().setNodeVersion("v" + config.nodeVersion().get()).setNodeDownloadRoot(config.nodeDownloadRoot()).setNpmVersion(config.npmVersion()).install();
        }
        catch (InstallationException e) {
            if (e.getCause() instanceof DirectoryNotEmptyException && e.getCause().getMessage().contains("tmp")) {
                LOG.warnf("Quinoa was not able to delete the Node install temporary directory: %s", (Object)e.getCause().getMessage());
            }
            throw e;
        }
        String executionPath = NPM_PATH;
        String npmVersion = config.npmVersion();
        boolean isNpmProvided = "provided".equalsIgnoreCase(npmVersion);
        if (!isNpmProvided) {
            factory.getNPMInstaller().setNodeVersion("v" + config.nodeVersion().get()).setNpmVersion(npmVersion).setNpmDownloadRoot(config.npmDownloadRoot()).install();
        }
        if ((yarnVersion = config.yarnVersion()).isPresent() && isNpmProvided) {
            executionPath = YARN_PATH;
            factory.getYarnInstaller().setIsYarnBerry(PackageManagerType.isYarnBerry(uiDir)).setYarnVersion("v" + config.yarnVersion().get()).setYarnDownloadRoot(config.yarnDownloadRoot()).setIsYarnBerry(true).install();
        }
        if ((pnpmVersion = config.pnpmVersion()).isPresent() && isNpmProvided && yarnVersion.isEmpty()) {
            executionPath = PNPM_PATH;
            factory.getPnpmInstaller().setNodeVersion("v" + config.nodeVersion().get()).setPnpmVersion(pnpmVersion.get()).setPnpmDownloadRoot(config.pnpmDownloadRoot()).install();
        }
        return PackageManagerInstall.resolveInstalledExecutorBinary(installDir, executionPath);
    }

    private static Path resolveInstallDir(PackageManagerInstallConfig config, Path projectDir) {
        Path installPath = Path.of(config.installDir().trim(), new String[0]);
        if (installPath.isAbsolute()) {
            return installPath;
        }
        if (projectDir == null) {
            throw new ConfigurationException("Use an absolute package-manager-install.install-dir when the project root directory is not standard", Set.of("quarkus.quinoa.package-manager-install.install-dir"));
        }
        return projectDir.resolve(installPath);
    }

    private static Installation resolveInstalledExecutorBinary(Path installDirectory, String executionPath) {
        Path nodeDirPath = installDirectory.resolve(INSTALL_SUB_PATH).toAbsolutePath();
        Path executorPath = installDirectory.resolve(executionPath).toAbsolutePath();
        String platformNodeDirPath = PackageManagerInstall.normalizePath(nodeDirPath.toString());
        String platformExecutorPath = PackageManagerInstall.normalizePath(executorPath.toString());
        String packageManagerBinary = NODE_BINARY + " " + PackageManagerInstall.quotePathWithSpaces(platformExecutorPath);
        return new Installation(platformNodeDirPath, packageManagerBinary);
    }

    public static String normalizePath(String path) {
        return PackageManagerRunner.isWindows() ? path.replaceAll("/", "\\\\") : path;
    }

    public static String quotePathWithSpaces(String path) {
        return path.contains(" ") ? "\"".concat(path).concat("\"") : path;
    }

    public static class Installation {
        private final String nodeDirPath;
        private final String packageManagerBinary;

        public Installation(String nodeDirPath, String packageManagerBinary) {
            this.nodeDirPath = nodeDirPath;
            this.packageManagerBinary = packageManagerBinary;
        }

        public String getNodeDirPath() {
            return this.nodeDirPath;
        }

        public String getPackageManagerBinary() {
            return this.packageManagerBinary;
        }
    }
}

