/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.items;

import io.quarkus.builder.item.SimpleBuildItem;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class BuiltResourcesBuildItem
extends SimpleBuildItem {
    private final Optional<Path> directory;
    private final Set<BuiltResource> resources;

    public BuiltResourcesBuildItem(Path directory, Set<BuiltResource> resources) {
        this.directory = Optional.ofNullable(directory);
        this.resources = resources;
    }

    public BuiltResourcesBuildItem(Set<BuiltResource> entries) {
        this.directory = Optional.empty();
        this.resources = entries;
    }

    public Optional<Path> getDirectory() {
        return this.directory;
    }

    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>(this.resources.size());
        for (BuiltResource entry : this.resources) {
            names.add(entry.getName());
        }
        return names;
    }

    public static class BuiltResource {
        private final String name;

        public BuiltResource(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuiltResource entry = (BuiltResource)o;
            return this.name.equals(entry.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

