/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.devui;

import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.items.ConfiguredQuinoaBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.util.Optional;

public class QuinoaDevUIProcessor {
    private static final String EXTENSION_NAME = "Quinoa";

    @BuildStep(onlyIf={IsDevelopment.class})
    void createCard(BuildProducer<CardPageBuildItem> cardPageBuildItemBuildProducer, BuildProducer<FooterPageBuildItem> footerProducer, Optional<ConfiguredQuinoaBuildItem> configuredQuinoa) {
        Optional<Integer> port;
        String npmVersion;
        PageBuilder nodejsPage;
        if (configuredQuinoa.isEmpty()) {
            return;
        }
        QuinoaConfig quinoaConfig = configuredQuinoa.get().resolvedConfig();
        CardPageBuildItem card = new CardPageBuildItem();
        Optional<String> node = quinoaConfig.packageManagerInstall().nodeVersion();
        if (node.isPresent()) {
            String nodeVersion = node.get();
            nodejsPage = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Node.js").icon("font-awesome-brands:square-js")).url("https://nodejs.org/").doNotEmbed().staticLabel(nodeVersion);
            card.addPage(nodejsPage);
        }
        if (!"provided".equalsIgnoreCase(npmVersion = quinoaConfig.packageManagerInstall().npmVersion())) {
            nodejsPage = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"NPM").icon("font-awesome-brands:square-js")).url("https://www.npmjs.com/").doNotEmbed().staticLabel(npmVersion);
            card.addPage(nodejsPage);
        } else {
            Optional<String> yarnVersion;
            Optional<String> pnpmVersion = quinoaConfig.packageManagerInstall().pnpmVersion();
            if (pnpmVersion.isPresent()) {
                PageBuilder nodejsPage2 = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"PNPM").icon("font-awesome-brands:square-js")).url("https://pnpm.io/").doNotEmbed().staticLabel(pnpmVersion.get());
                card.addPage(nodejsPage2);
            }
            if ((yarnVersion = quinoaConfig.packageManagerInstall().yarnVersion()).isPresent()) {
                PageBuilder nodejsPage3 = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Yarn").icon("font-awesome-brands:square-js")).url("https://yarnpkg.com/").doNotEmbed().staticLabel(yarnVersion.get());
                card.addPage(nodejsPage3);
            }
        }
        if (configuredQuinoa.isPresent() && (port = configuredQuinoa.get().resolvedConfig().devServer().port()).isPresent() && port.get() > 0) {
            PageBuilder portPage = (PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Port").icon("font-awesome-solid:plug")).url(String.format("https://localhost:%d", port.get())).doNotEmbed().staticLabel(String.valueOf(port.get()));
            card.addPage(portPage);
        }
        card.setCustomCard("qwc-quinoa-card.js");
        cardPageBuildItemBuildProducer.produce((BuildItem)card);
        WebComponentPageBuilder nodeLogPageBuilder = ((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().icon("font-awesome-brands:square-js")).title(EXTENSION_NAME)).componentLink("qwc-quinoa-log.js");
        footerProducer.produce((BuildItem)new FooterPageBuildItem(new PageBuilder[]{nodeLogPageBuilder}));
    }
}

