/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.framework;

import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.framework.FrameworkConfigOverrideFactory;
import io.quarkiverse.quinoa.deployment.framework.override.AngularFramework;
import io.quarkiverse.quinoa.deployment.framework.override.GenericFramework;
import io.quarkiverse.quinoa.deployment.framework.override.NextFramework;
import io.quarkiverse.quinoa.deployment.framework.override.ReactFramework;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public enum FrameworkType {
    REACT(Set.of("react-scripts start", "react-app-rewired start", "craco start"), new ReactFramework()),
    VUE_LEGACY(Set.of("vue-cli-service serve"), GenericFramework.generic("dist", "serve", 3000)),
    VITE(Set.of("vite"), GenericFramework.generic("dist", "dev", 5173)),
    SOLID_START(Set.of("solid-start dev"), GenericFramework.generic("dist", "dev", 3000)),
    ASTRO(Set.of("astro dev"), GenericFramework.generic("dist", "dev", 3000)),
    NEXT(Set.of("next dev"), new NextFramework()),
    NUXT(Set.of("nuxt dev"), GenericFramework.generic("dist", "dev", 3000)),
    ANGULAR(Set.of("ng serve"), new AngularFramework()),
    EMBER(Set.of("ember-cli serve"), GenericFramework.generic("dist", "serve", 4200)),
    GATSBY(Set.of("gatsby develop"), GenericFramework.generic("dist", "develop", 8000)),
    MIDWAYJS(Set.of("midway-bin dev"), GenericFramework.generic("dist", "dev", 7001));

    private static final Logger LOG;
    private static final Set<String> DEV_SCRIPTS;
    private static final Map<String, FrameworkType> TYPE_START_DEV_COMMAND_MAPPING;
    private final Set<String> cliStartDev;
    private final FrameworkConfigOverrideFactory factory;

    private FrameworkType(Set<String> cliStartDev, FrameworkConfigOverrideFactory factory) {
        this.cliStartDev = cliStartDev;
        this.factory = factory;
    }

    public FrameworkConfigOverrideFactory factory() {
        return this.factory;
    }

    public static QuinoaConfig overrideConfig(LaunchModeBuildItem launchMode, QuinoaConfig config, Path packageJsonFile) {
        if (!config.framework().detection()) {
            return GenericFramework.UNKNOWN_FRAMEWORK.override(config, Optional.empty(), Optional.empty(), true);
        }
        JsonObject packageJson = FrameworkType.readPackageJson(packageJsonFile);
        Optional<DetectedFramework> detectedFramework = FrameworkType.detectFramework(packageJson);
        if (detectedFramework.isEmpty()) {
            LOG.trace((Object)"Quinoa could not auto-detect the frameworkType from package.json file.");
            return GenericFramework.UNKNOWN_FRAMEWORK.override(config, Optional.of(packageJson), Optional.empty(), true);
        }
        FrameworkType frameworkType = detectedFramework.get().type;
        LOG.infof("Quinoa detected '%s' frameworkType from package.json file.", (Object)frameworkType);
        return frameworkType.factory.override(config, Optional.of(packageJson), Optional.of(detectedFramework.get().devScript), detectedFramework.get().isCustomized);
    }

    private static JsonObject readPackageJson(Path packageJsonFile) {
        JsonObject jsonObject;
        block8: {
            JsonReader reader = Json.createReader((InputStream)Files.newInputStream(packageJsonFile, new OpenOption[0]));
            try {
                jsonObject = reader.readObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonException | IOException e) {
                    throw new RuntimeException("Quinoa failed to read the package.json file. %s", e);
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    static Optional<DetectedFramework> detectFramework(JsonObject packageJson) {
        JsonObject scripts = packageJson.getJsonObject("scripts");
        if (scripts == null || scripts.isEmpty()) {
            return Optional.empty();
        }
        Map<String, String> projectDevScripts = scripts.entrySet().stream().filter(e -> DEV_SCRIPTS.contains(e.getKey()) && e.getValue() != null && JsonValue.ValueType.STRING.equals((Object)((JsonValue)e.getValue()).getValueType())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonString)e.getValue()).getString().trim().toLowerCase(Locale.US)));
        for (Map.Entry<String, String> e2 : projectDevScripts.entrySet()) {
            if (!TYPE_START_DEV_COMMAND_MAPPING.containsKey(e2.getValue())) continue;
            FrameworkType framework = TYPE_START_DEV_COMMAND_MAPPING.get(e2.getValue());
            String frameworkDefaultDevScript = framework.factory().getDefaultDevScriptName();
            LOG.debugf("Detected framework with dev command perfect match: %s", (Object)framework.toString());
            String projectDevScript = e2.getKey();
            boolean isDefaultDevCommand = projectDevScript.equals(frameworkDefaultDevScript);
            if (!isDefaultDevCommand) {
                LOG.warnf("%s framework typically defines a '%s' script in package.json file but found '%s' instead.", (Object)framework, (Object)frameworkDefaultDevScript, (Object)projectDevScript);
            }
            return Optional.of(new DetectedFramework(framework, projectDevScript, !isDefaultDevCommand));
        }
        for (Map.Entry<String, String> projectDevScriptEntry : projectDevScripts.entrySet()) {
            for (Map.Entry<String, FrameworkType> frameworksByCommand : TYPE_START_DEV_COMMAND_MAPPING.entrySet()) {
                FrameworkType framework = frameworksByCommand.getValue();
                String frameworkDefaultDevScript = framework.factory().getDefaultDevScriptName();
                String frameworkCommand = frameworksByCommand.getKey();
                String projectDevScript = projectDevScriptEntry.getKey();
                String projectDevCommand = projectDevScriptEntry.getValue();
                boolean detected = projectDevCommand.contains(frameworkCommand);
                if (!detected) continue;
                boolean isDefaultDevCommand = projectDevScript.equals(frameworkDefaultDevScript);
                boolean endsWith = projectDevCommand.endsWith(frameworkCommand);
                if (isDefaultDevCommand || projectDevScripts.size() == 1) {
                    if (!isDefaultDevCommand) {
                        LOG.warnf("%s framework typically defines a '%s` script in package.json file but found '%s' instead.", (Object)framework, (Object)frameworkDefaultDevScript, (Object)projectDevScript);
                    }
                    return Optional.of(new DetectedFramework(framework, projectDevScript, !isDefaultDevCommand || !endsWith));
                }
                LOG.errorf("Framework detection failed: It is probably %s framework which typically defines a '%s' script in package.json but found multiple other dev scripts instead (%s).", (Object)framework, (Object)frameworkDefaultDevScript, (Object)String.join((CharSequence)", ", projectDevScripts.keySet()));
            }
        }
        return Optional.empty();
    }

    private static FrameworkType resolveFramework(String script) {
        String normalizedScript = script.toLowerCase(Locale.ROOT).trim();
        for (FrameworkType value : FrameworkType.values()) {
            for (String cliName : value.cliStartDev) {
                if (!normalizedScript.contains(cliName)) continue;
                return value;
            }
        }
        return null;
    }

    static {
        LOG = Logger.getLogger(FrameworkType.class);
        DEV_SCRIPTS = Arrays.stream(FrameworkType.values()).map(framework -> framework.factory.getDefaultDevScriptName()).collect(Collectors.toCollection(TreeSet::new));
        TYPE_START_DEV_COMMAND_MAPPING = Arrays.stream(FrameworkType.values()).flatMap(t -> t.cliStartDev.stream().map(c -> new AbstractMap.SimpleImmutableEntry<String, FrameworkType>((String)c, (FrameworkType)((Object)t)))).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, AbstractMap.SimpleImmutableEntry::getValue));
    }

    static class DetectedFramework {
        public final FrameworkType type;
        public final String devScript;
        public final boolean isCustomized;

        public DetectedFramework(FrameworkType type, String devScript, boolean isCustomized) {
            this.type = type;
            this.devScript = devScript;
            this.isCustomized = isCustomized;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DetectedFramework that = (DetectedFramework)o;
            return this.isCustomized == that.isCustomized && this.type == that.type && Objects.equals(this.devScript, that.devScript);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.devScript, this.isCustomized});
        }

        public String toString() {
            return new StringJoiner(", ", DetectedFramework.class.getSimpleName() + "[", "]").add("type=" + this.type).add("devScript='" + this.devScript + "'").add("isCustomized=" + this.isCustomized).toString();
        }
    }
}

