/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment;

import io.quarkiverse.quinoa.QuinoaRecorder;
import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.framework.FrameworkType;
import io.quarkiverse.quinoa.deployment.items.BuiltResourcesBuildItem;
import io.quarkiverse.quinoa.deployment.items.ConfiguredQuinoaBuildItem;
import io.quarkiverse.quinoa.deployment.items.InstalledPackageManagerBuildItem;
import io.quarkiverse.quinoa.deployment.items.TargetDirBuildItem;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerInstall;
import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerRunner;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManagerType;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.spi.GeneratedStaticResourceBuildItem;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class QuinoaProcessor {
    private static final Logger LOG = Logger.getLogger(QuinoaProcessor.class);
    private static final Set<String> IGNORE_WATCH = Set.of("node_modules", "target");
    private static final Set<String> IGNORE_WATCH_LOCKFILES = Arrays.stream(PackageManagerType.values()).map(PackageManagerType::getLockFile).collect(Collectors.toSet());
    private static final Set<String> IGNORE_WATCH_BUILD_DIRS = ((Stream)Arrays.stream(FrameworkType.values()).sequential()).map(frameworkType -> frameworkType.factory().getDefaultBuildDir()).collect(Collectors.toSet());
    private static final Pattern IGNORE_WATCH_REGEX = Pattern.compile("^[.].+$");
    private static final String FEATURE = "quinoa";
    private static final String TARGET_DIR_NAME = "quinoa";
    private static final String TARGET_BUILD_DIR_NAME = "build";
    private static final String BUILD_FILE = "package.json";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("quinoa");
    }

    @BuildStep
    public ConfiguredQuinoaBuildItem prepareQuinoaDirectory(LaunchModeBuildItem launchMode, QuinoaConfig userConfig, OutputTargetBuildItem outputTarget) throws IOException {
        if (!QuinoaConfig.isEnabled(userConfig)) {
            LOG.info((Object)"Quinoa is disabled.");
            return null;
        }
        if (launchMode.isTest() && userConfig.enabled().isEmpty()) {
            LOG.warn((Object)"Quinoa is disabled by default in tests.");
            return null;
        }
        String configuredDir = userConfig.uiDir();
        ProjectDirs projectDirs = QuinoaProcessor.resolveProjectDirs(userConfig, outputTarget);
        if (projectDirs == null) {
            return null;
        }
        Path packageJson = projectDirs.uiDir.resolve(BUILD_FILE);
        if (!Files.isRegularFile(packageJson, new LinkOption[0])) {
            throw new ConfigurationException("No package.json found in Web UI directory: '" + configuredDir + "'");
        }
        QuinoaProcessor.initializeTargetDirectory(outputTarget);
        QuinoaConfig resolvedConfig = FrameworkType.overrideConfig(launchMode, userConfig, packageJson);
        return new ConfiguredQuinoaBuildItem(projectDirs.projectRootDir, projectDirs.uiDir, packageJson, resolvedConfig);
    }

    @BuildStep
    public InstalledPackageManagerBuildItem install(ConfiguredQuinoaBuildItem configuredQuinoa, LiveReloadBuildItem liveReload, OutputTargetBuildItem outputTarget) throws IOException {
        if (configuredQuinoa != null) {
            QuinoaConfig resolvedConfig = configuredQuinoa.resolvedConfig();
            Optional<String> packageManagerBinary = resolvedConfig.packageManager();
            ArrayList<String> paths = new ArrayList<String>();
            if (resolvedConfig.packageManagerInstall().enabled()) {
                PackageManagerInstall.Installation result = PackageManagerInstall.install(resolvedConfig.packageManagerInstall(), configuredQuinoa.projectDir(), configuredQuinoa.uiDir());
                packageManagerBinary = Optional.of(result.getPackageManagerBinary());
                paths.add(result.getNodeDirPath());
            }
            PackageManagerRunner packageManagerRunner = PackageManagerRunner.autoDetectPackageManager(packageManagerBinary, resolvedConfig.packageManagerCommand(), configuredQuinoa.uiDir(), paths);
            Path targetPackageJson = outputTarget.getOutputDirectory().resolve("quinoa").resolve(BUILD_FILE);
            Path currentPackageJson = configuredQuinoa.packageJson();
            if (resolvedConfig.forceInstall() || QuinoaProcessor.shouldInstallPackages(configuredQuinoa, liveReload, targetPackageJson, currentPackageJson)) {
                boolean ci = resolvedConfig.ci().orElseGet(QuinoaProcessor::isCI);
                if (ci) {
                    packageManagerRunner.ci();
                } else {
                    packageManagerRunner.install();
                }
                Files.copy(currentPackageJson, targetPackageJson, StandardCopyOption.REPLACE_EXISTING);
            }
            return new InstalledPackageManagerBuildItem(packageManagerRunner);
        }
        return null;
    }

    @BuildStep
    public TargetDirBuildItem processBuild(ConfiguredQuinoaBuildItem configuredQuinoa, InstalledPackageManagerBuildItem installedPackageManager, OutputTargetBuildItem outputTarget, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReload) throws IOException {
        if (configuredQuinoa == null) {
            return null;
        }
        PackageManagerRunner packageManagerRunner = installedPackageManager.getPackageManager();
        QuinoaLiveContext contextObject = (QuinoaLiveContext)liveReload.getContextObject(QuinoaLiveContext.class);
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT && QuinoaConfig.isDevServerMode(configuredQuinoa.resolvedConfig())) {
            return null;
        }
        if (liveReload.isLiveReload() && liveReload.getChangedResources().stream().noneMatch(r -> r.startsWith(packageManagerRunner.getDirectory().toString())) && contextObject != null) {
            return new TargetDirBuildItem(contextObject.getLocation());
        }
        if (configuredQuinoa.resolvedConfig().runTests()) {
            packageManagerRunner.test();
        }
        packageManagerRunner.build(launchMode.getLaunchMode());
        String configuredBuildDir = configuredQuinoa.resolvedConfig().buildDir().orElseThrow();
        Path buildDir = packageManagerRunner.getDirectory().resolve(configuredBuildDir);
        if (!Files.isDirectory(buildDir, new LinkOption[0])) {
            throw new ConfigurationException("Quinoa build directory not found: '" + buildDir.toAbsolutePath() + "'", Set.of("quarkus.quinoa.build-dir"));
        }
        Path targetBuildDir = QuinoaProcessor.initializeTargetDirectory(outputTarget).resolve(TARGET_BUILD_DIR_NAME);
        FileUtil.deleteDirectory((Path)targetBuildDir);
        try {
            Files.move(buildDir, targetBuildDir, new CopyOption[0]);
        }
        catch (IOException e) {
            String message = String.format("Error moving directory '%s -> %s'. Please make sure no files are open such as in Files Explorer or other tools.", buildDir, targetBuildDir);
            throw new IOException(message, e);
        }
        liveReload.setContextObject(QuinoaLiveContext.class, (Object)new QuinoaLiveContext(targetBuildDir));
        return new TargetDirBuildItem(targetBuildDir);
    }

    @BuildStep
    public BuiltResourcesBuildItem prepareBuiltResources(Optional<TargetDirBuildItem> targetDir) throws IOException {
        if (targetDir.isEmpty()) {
            return null;
        }
        return new BuiltResourcesBuildItem(this.lookupBuiltResources(targetDir.get().getBuildDirectory()));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void watchChanges(Optional<ConfiguredQuinoaBuildItem> quinoaDir, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        if (quinoaDir.isEmpty()) {
            return;
        }
        if (QuinoaConfig.isDevServerMode(quinoaDir.get().resolvedConfig())) {
            HotDeploymentWatchedFileBuildItem watchPackageJson = HotDeploymentWatchedFileBuildItem.builder().setLocation(quinoaDir.get().packageJson().toString()).setRestartNeeded(true).build();
            watchedPaths.produce((BuildItem)watchPackageJson);
            return;
        }
        this.scan(quinoaDir.get().uiDir(), quinoaDir.get().uiDir(), watchedPaths);
    }

    @BuildStep
    public void produceGeneratedStaticResources(ConfiguredQuinoaBuildItem configuredQuinoa, BuildProducer<GeneratedStaticResourceBuildItem> generatedStaticResourceProducer, Optional<BuiltResourcesBuildItem> uiResources) {
        if (configuredQuinoa != null && configuredQuinoa.resolvedConfig().justBuild()) {
            LOG.info((Object)"Quinoa is in build only mode");
            return;
        }
        if (uiResources.isPresent() && !uiResources.get().resources().isEmpty()) {
            String uiRootPath = QuinoaConfig.getNormalizedUiRootPath(configuredQuinoa.resolvedConfig());
            for (BuiltResourcesBuildItem.BuiltResource resource : uiResources.get().resources()) {
                generatedStaticResourceProducer.produce((BuildItem)new GeneratedStaticResourceBuildItem(uiRootPath + resource.name().substring(1), resource.content()));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(ConfiguredQuinoaBuildItem configuredQuinoa, HttpRootPathBuildItem httpRootPath, NonApplicationRootPathBuildItem nonApplicationRootPath, QuinoaRecorder recorder, BuildProducer<RouteBuildItem> routes, Optional<BuiltResourcesBuildItem> uiResources) throws IOException {
        if (configuredQuinoa != null && configuredQuinoa.resolvedConfig().justBuild()) {
            return;
        }
        if (uiResources.isPresent() && !uiResources.get().resources().isEmpty()) {
            String uiRootPath = QuinoaConfig.getNormalizedUiRootPath(configuredQuinoa.resolvedConfig());
            String resolvedUiRootPath = httpRootPath.relativePath(uiRootPath);
            recorder.logUiRootPath((String)(resolvedUiRootPath.endsWith("/") ? resolvedUiRootPath : resolvedUiRootPath + "/"));
            if (Objects.requireNonNull(configuredQuinoa).resolvedConfig().enableSPARouting()) {
                routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute(uiRootPath + "*", Integer.valueOf(40000)).handler(recorder.quinoaSPARoutingHandler(QuinoaConfig.getNormalizedIgnoredPathPrefixes(configuredQuinoa.resolvedConfig(), nonApplicationRootPath))).build());
            }
        }
    }

    private HashSet<BuiltResourcesBuildItem.BuiltResource> lookupBuiltResources(Path targetDir) throws IOException {
        try (Stream<Path> paths = Files.walk(targetDir, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            List<Path> files = paths.toList();
            HashSet<BuiltResourcesBuildItem.BuiltResource> entries = new HashSet<BuiltResourcesBuildItem.BuiltResource>(files.size());
            LOG.infof("Quinoa target directory: '%s'", (Object)targetDir);
            for (Path file : files) {
                String name = "/" + targetDir.relativize(file).toString().replace('\\', '/');
                LOG.infof("Quinoa generated resource: '%s'", (Object)name);
                entries.add(new BuiltResourcesBuildItem.BuiltResource(name, Files.readAllBytes(file)));
            }
            HashSet<BuiltResourcesBuildItem.BuiltResource> hashSet = entries;
            return hashSet;
        }
    }

    private void scan(Path uiDir, Path directory, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                String relativePath = uiDir.relativize(filePath).toString();
                if (QuinoaProcessor.shouldWatch(relativePath)) {
                    if (Files.isRegularFile(filePath, new LinkOption[0])) {
                        LOG.debugf("Quinoa is watching: %s", (Object)filePath);
                        watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(filePath.toString()));
                        continue;
                    }
                    LOG.debugf("Quinoa is scanning directory: %s", (Object)filePath);
                    this.scan(uiDir, filePath, watchedPaths);
                    continue;
                }
                LOG.debugf("'%s' is set to be ignored by dev-mode watch", (Object)relativePath);
            }
        }
    }

    private static boolean shouldInstallPackages(ConfiguredQuinoaBuildItem configuredQuinoa, LiveReloadBuildItem liveReload, Path targetPackageJson, Path currentPackageJson) throws IOException {
        if (!Files.isDirectory(configuredQuinoa.uiDir().resolve("node_modules"), new LinkOption[0])) {
            LOG.info((Object)"Quinoa didn't detect a node_modules directory, let's install packages...");
            return true;
        }
        if (QuinoaProcessor.isPackageJsonLiveReloadChanged(configuredQuinoa, liveReload)) {
            return true;
        }
        if (!Files.exists(targetPackageJson, new LinkOption[0])) {
            LOG.info((Object)"Fresh Quinoa build, let's install packages...");
            return true;
        }
        if (Files.size(currentPackageJson) != Files.size(targetPackageJson) || !Arrays.equals(Files.readAllBytes(currentPackageJson), Files.readAllBytes(targetPackageJson))) {
            LOG.info((Object)"Quinoa detected a change in package.json since the previous install, let's install packages again...");
            return true;
        }
        LOG.debug((Object)"package.json seems to be the same as previous Quinoa install, skipping packages install");
        return false;
    }

    static boolean isPackageJsonLiveReloadChanged(ConfiguredQuinoaBuildItem configuredQuinoa, LiveReloadBuildItem liveReload) {
        return liveReload.isLiveReload() && liveReload.getChangedResources().stream().anyMatch(r -> r.equals(configuredQuinoa.packageJson().toString()));
    }

    private static boolean shouldWatch(String relativeFilePath) {
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.addAll(IGNORE_WATCH);
        ignoreSet.addAll(IGNORE_WATCH_LOCKFILES);
        ignoreSet.addAll(IGNORE_WATCH_BUILD_DIRS);
        return !ignoreSet.contains(relativeFilePath) && !IGNORE_WATCH_REGEX.matcher(relativeFilePath).matches();
    }

    private static ProjectDirs resolveProjectDirs(QuinoaConfig config, OutputTargetBuildItem outputTarget) {
        Path projectRoot = QuinoaProcessor.findProjectRoot(outputTarget.getOutputDirectory());
        Path configuredUIDirPath = Path.of(config.uiDir().trim(), new String[0]);
        if (projectRoot == null || !Files.isDirectory(projectRoot, new LinkOption[0])) {
            if (configuredUIDirPath.isAbsolute() && Files.isDirectory(configuredUIDirPath, new LinkOption[0])) {
                return new ProjectDirs(null, configuredUIDirPath.normalize());
            }
            throw new IllegalStateException("If not absolute, the Web UI directory is resolved relative to the project root, but Quinoa was not able to find the project root.");
        }
        Path uiRoot = projectRoot.resolve(configuredUIDirPath).normalize();
        if (!Files.isDirectory(uiRoot, new LinkOption[0])) {
            LOG.warnf("Quinoa directory not found 'quarkus.quinoa.ui-dir=%s' resolved to '%s'. It is recommended to remove the quarkus-quinoa extension if not used.", (Object)config.uiDir(), (Object)uiRoot.toAbsolutePath());
            return null;
        }
        return new ProjectDirs(projectRoot, uiRoot);
    }

    static Path findProjectRoot(Path outputDirectory) {
        Path currentPath = outputDirectory;
        while (true) {
            if (Files.exists(currentPath.resolve(Paths.get("src", "main")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.properties")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yaml")), new LinkOption[0]) || Files.exists(currentPath.resolve(Paths.get("config", "application.yml")), new LinkOption[0])) {
                return currentPath.normalize();
            }
            if (currentPath.getParent() == null || !Files.exists(currentPath.getParent(), new LinkOption[0])) break;
            currentPath = currentPath.getParent();
        }
        return null;
    }

    private static boolean isCI() {
        String ci = System.getProperties().containsKey("CI") ? System.getProperty("CI") : System.getenv().getOrDefault("CI", "false");
        return Objects.equals(ci, "true");
    }

    public static Path initializeTargetDirectory(OutputTargetBuildItem outputTarget) throws IOException {
        Path targetBuildDir = outputTarget.getOutputDirectory().resolve("quinoa");
        Files.createDirectories(targetBuildDir, new FileAttribute[0]);
        return targetBuildDir;
    }

    public static class ProjectDirs {
        private final Path projectRootDir;
        private final Path uiDir;

        public ProjectDirs(Path projectRootDir, Path uiDir) {
            this.projectRootDir = projectRootDir;
            this.uiDir = uiDir;
        }

        public Path getProjectRootDir() {
            return this.projectRootDir;
        }

        public Path getUIDir() {
            return this.uiDir;
        }
    }

    private static class QuinoaLiveContext {
        private final Path location;

        private QuinoaLiveContext(Path location) {
            this.location = location;
        }

        public Path getLocation() {
            return this.location;
        }
    }
}

