/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.framework.override;

import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.config.delegate.PackageManagerCommandConfigDelegate;
import io.quarkiverse.quinoa.deployment.config.delegate.QuinoaConfigDelegate;
import io.quarkiverse.quinoa.deployment.framework.override.GenericFramework;
import jakarta.json.JsonObject;
import java.util.Optional;

public class AngularFramework
extends GenericFramework {
    public AngularFramework() {
        super("dist", "start", 4200);
    }

    @Override
    public QuinoaConfig override(final QuinoaConfig originalConfig, final Optional<JsonObject> packageJson, Optional<String> detectedDevScript, final boolean isCustomized) {
        final String devScript = detectedDevScript.orElse(this.getDefaultDevScriptName());
        return new QuinoaConfigDelegate(super.override(originalConfig, packageJson, detectedDevScript, isCustomized)){

            @Override
            public Optional<String> buildDir() {
                String applicationName = packageJson.map(p -> p.getString("name")).orElse("quinoa");
                String fullBuildDir = String.format("%s/%s", AngularFramework.this.getDefaultBuildDir(), applicationName);
                return Optional.of(originalConfig.buildDir().orElse(fullBuildDir));
            }

            @Override
            public PackageManagerCommandConfig packageManagerCommand() {
                return new PackageManagerCommandConfigDelegate(super.packageManagerCommand()){

                    @Override
                    public Optional<String> dev() {
                        String extraArgs = isCustomized ? "" : " -- --disable-host-check --hmr";
                        return Optional.of(originalConfig.packageManagerCommand().dev().orElse("run " + devScript + extraArgs));
                    }

                    @Override
                    public Optional<String> test() {
                        String extraArgs = isCustomized ? "" : " -- --no-watch --no-progress --browsers=ChromeHeadlessCI";
                        return Optional.of(originalConfig.packageManagerCommand().test().orElse("run test" + extraArgs));
                    }
                };
            }
        };
    }
}

