/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.framework.override;

import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.config.QuinoaConfig;
import io.quarkiverse.quinoa.deployment.config.delegate.PackageManagerCommandConfigDelegate;
import io.quarkiverse.quinoa.deployment.config.delegate.QuinoaConfigDelegate;
import io.quarkiverse.quinoa.deployment.framework.override.GenericFramework;
import io.quarkus.logging.Log;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;

public class AngularFramework
extends GenericFramework {
    public static final String ANGULAR_DEVKIT_BUILD_ANGULAR_APPLICATION = "@angular-devkit/build-angular:application";
    public static final String ANGULAR_JSON_FILE = "angular.json";

    public AngularFramework() {
        super("dist", "start", 4200);
    }

    @Override
    public QuinoaConfig override(final QuinoaConfig originalConfig, final Optional<JsonObject> packageJson, Optional<String> detectedDevScript, final boolean isCustomized) {
        final String devScript = detectedDevScript.orElse(this.getDefaultDevScriptName());
        return new QuinoaConfigDelegate(super.override(originalConfig, packageJson, detectedDevScript, isCustomized)){

            @Override
            public Optional<String> buildDir() {
                String applicationName = packageJson.map(p -> p.getString("name")).orElse("quinoa");
                JsonObject angularJson = 1.readAngularJson(originalConfig);
                String builder = 1.getBuilderUse(angularJson, applicationName);
                String fullBuildDir = String.format("%s/%s", AngularFramework.this.getDefaultBuildDir(), applicationName);
                if (AngularFramework.ANGULAR_DEVKIT_BUILD_ANGULAR_APPLICATION.equals(builder)) {
                    fullBuildDir = String.format("%s/browser", fullBuildDir);
                }
                return Optional.of(originalConfig.buildDir().orElse(fullBuildDir));
            }

            private static JsonObject readAngularJson(QuinoaConfig configuration) {
                JsonObject jsonObject;
                block8: {
                    Log.debug((Object)("=== Configuration ===" + configuration));
                    JsonReader reader = Json.createReader((InputStream)Files.newInputStream(Path.of(configuration.uiDir() + "/angular.json", new String[0]), new OpenOption[0]));
                    try {
                        jsonObject = reader.readObject();
                        if (reader == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (JsonException | IOException e) {
                            throw new RuntimeException("Quinoa failed to read the angular.json file. %s", e);
                        }
                    }
                    reader.close();
                }
                return jsonObject;
            }

            private static String getBuilderUse(JsonObject angularJson, String applicationName) {
                return angularJson.getJsonObject("projects").getJsonObject(applicationName).getJsonObject("architect").getJsonObject("build").getString("builder");
            }

            @Override
            public PackageManagerCommandConfig packageManagerCommand() {
                return new PackageManagerCommandConfigDelegate(super.packageManagerCommand()){

                    @Override
                    public Optional<String> dev() {
                        String extraArgs = isCustomized ? "" : " -- --disable-host-check --hmr";
                        return Optional.of(originalConfig.packageManagerCommand().dev().orElse("run " + devScript + extraArgs));
                    }

                    @Override
                    public Optional<String> test() {
                        String extraArgs = isCustomized ? "" : " -- --no-watch --no-progress --browsers=ChromeHeadlessCI";
                        return Optional.of(originalConfig.packageManagerCommand().test().orElse("run test" + extraArgs));
                    }
                };
            }
        };
    }
}

