/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager;

import io.quarkiverse.quinoa.QuinoaNetworkConfiguration;
import io.quarkiverse.quinoa.deployment.SslUtil;
import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManager;
import io.quarkiverse.quinoa.deployment.packagemanager.types.PackageManagerType;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.util.ProcessUtil;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;

public class PackageManagerRunner {
    private static final Logger LOG = Logger.getLogger(PackageManagerRunner.class);
    public static final Predicate<Thread> DEV_PROCESS_THREAD_PREDICATE = thread -> thread.getName().matches("Process (stdout|stderr) streamer");
    private final Path directory;
    private final PackageManager packageManager;

    private PackageManagerRunner(Path directory, PackageManager packageManager) {
        this.directory = directory;
        this.packageManager = packageManager;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public void ci() {
        PackageManager.Command ci = this.packageManager.ci();
        LOG.infof("Running Quinoa package manager ci command: %s", (Object)ci.commandWithArguments);
        if (!this.exec(ci)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager ci command: %s", ci.commandWithArguments));
        }
    }

    public void install() {
        PackageManager.Command install = this.packageManager.install();
        LOG.infof("Running Quinoa package manager install command: %s", (Object)install.commandWithArguments);
        if (!this.exec(install)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager install command: %s", install.commandWithArguments));
        }
    }

    public void build(LaunchMode mode) {
        PackageManager.Command build = this.packageManager.build(mode);
        LOG.infof("Running Quinoa package manager build command: %s", (Object)build.commandWithArguments);
        if (!this.exec(build)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager build command: %s", build.commandWithArguments));
        }
    }

    public void test() {
        PackageManager.Command test = this.packageManager.test();
        LOG.infof("Running Quinoa package manager test command: %s", (Object)test.commandWithArguments);
        if (!this.exec(test)) {
            throw new RuntimeException(String.format("Error in Quinoa while running package manager test command: %s", test.commandWithArguments));
        }
    }

    public void stopDev(Process process) {
        if (process == null || !process.isAlive()) {
            return;
        }
        LOG.infof("Stopping Quinoa package manager live coding as a dev service.", new Object[0]);
        try {
            PackageManagerRunner.killDescendants(process.toHandle(), false);
            if (process.isAlive()) {
                process.destroy();
                PackageManagerRunner.killDescendants(process.toHandle(), true);
                if (!process.waitFor(10L, TimeUnit.SECONDS)) {
                    process.destroyForcibly();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.errorf((Throwable)e, "Error while waiting for Quinoa Dev Server process (#%s) to exit.", (Object)process.pid());
        }
        finally {
            if (process.isAlive()) {
                LOG.warnf("Quinoa was not able to stop the Dev Server process (#%s).", (Object)process.pid());
            }
        }
    }

    private static void killDescendants(ProcessHandle process, boolean force) {
        process.children().forEach(child -> {
            PackageManagerRunner.killDescendants(child, force);
            if (child.isAlive()) {
                if (force) {
                    child.destroyForcibly();
                } else {
                    child.destroy();
                }
            }
        });
    }

    public DevServer dev(Optional<ConsoleInstalledBuildItem> consoleInstalled, LoggingSetupBuildItem loggingSetup, QuinoaNetworkConfiguration network, String checkPath, int checkTimeout) {
        PackageManager.Command dev = this.packageManager.dev();
        LOG.infof("Running Quinoa package manager live coding as a dev service: %s", (Object)dev.commandWithArguments);
        StartupLogCompressor logCompressor = new StartupLogCompressor("Quinoa package manager live coding dev service starting:", consoleInstalled, loggingSetup, DEV_PROCESS_THREAD_PREDICATE);
        final Process p = this.process(dev);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                PackageManagerRunner.this.stopDev(p);
            }
        });
        if (checkPath == null) {
            LOG.infof("Quinoa is configured to continue without check if the live coding server is up", new Object[0]);
            return new DevServer(p, network.getHost(), logCompressor);
        }
        String ipAddress = null;
        try {
            int i = 0;
            while ((ipAddress = PackageManagerRunner.isDevServerUp(network, checkPath)) == null) {
                if (++i >= checkTimeout / 500) {
                    this.stopDev(p);
                    throw new RuntimeException("Quinoa package manager live coding port " + network.getPort() + " is still not listening after the checkTimeout.");
                }
                Thread.sleep(500L);
            }
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.stopDev(p);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return new DevServer(p, ipAddress, logCompressor);
    }

    public static PackageManagerRunner autoDetectPackageManager(Optional<String> configuredBinary, PackageManagerCommandConfig packageManagerCommands, Path directory, List<String> paths) {
        String binary;
        PackageManagerType type = PackageManagerType.detectPackageManagerType(directory);
        if (configuredBinary.isEmpty()) {
            binary = type.getOSBinary();
        } else {
            binary = configuredBinary.get();
            type = PackageManagerType.resolveConfiguredPackageManagerType(binary, type);
        }
        return new PackageManagerRunner(directory, PackageManager.resolve(type, binary, packageManagerCommands, paths));
    }

    public static boolean isWindows() {
        return QuarkusConsole.IS_WINDOWS;
    }

    private Process process(PackageManager.Command command) {
        Process process = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(this.directory.toFile()).command(this.runner(command));
        if (!command.envs.isEmpty()) {
            builder.environment().putAll(command.envs);
        }
        try {
            process = ProcessUtil.launchProcess((ProcessBuilder)builder, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while running process.", e);
        }
        return process;
    }

    private boolean exec(PackageManager.Command command) {
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (!command.envs.isEmpty()) {
                processBuilder.environment().putAll(command.envs);
            }
            process = processBuilder.directory(this.directory.toFile()).command(this.runner(command)).redirectErrorStream(true).start();
            new HandleOutput(process.getInputStream()).run();
            process.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Input/Output error while executing command.", e);
        }
        catch (InterruptedException e) {
            return false;
        }
        return process != null && process.exitValue() == 0;
    }

    private String[] runner(PackageManager.Command command) {
        if (PackageManagerRunner.isWindows()) {
            return new String[]{"cmd.exe", "/c", command.commandWithArguments};
        }
        return new String[]{"sh", "-c", command.commandWithArguments};
    }

    public static String isDevServerUp(QuinoaNetworkConfiguration network, String path) {
        if (path == null) {
            return network.getHost();
        }
        Object normalizedPath = path.indexOf("/") == 0 ? path : "/" + path;
        try {
            InetAddress[] addresses;
            for (InetAddress address : addresses = InetAddress.getAllByName(network.getHost())) {
                try {
                    HttpURLConnection connection;
                    String hostAddress = address.getHostAddress();
                    Object ipAddress = address instanceof Inet6Address ? "[" + hostAddress + "]" : hostAddress;
                    URL url = new URL(String.format("%s://%s:%d%s", network.isTls() ? "https" : "http", ipAddress, network.getPort(), normalizedPath));
                    if (network.isTls()) {
                        HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
                        if (network.isTlsAllowInsecure()) {
                            httpsConnection.setSSLSocketFactory(SslUtil.createNonValidatingSslContext().getSocketFactory());
                            httpsConnection.setHostnameVerifier(new HostnameVerifier(){

                                @Override
                                public boolean verify(String hostname, SSLSession session) {
                                    return true;
                                }
                            });
                        }
                        connection = httpsConnection;
                    } else {
                        connection = (HttpURLConnection)url.openConnection();
                    }
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(2000);
                    connection.setReadTimeout(2000);
                    connection.connect();
                    int code = connection.getResponseCode();
                    return code == 200 ? ipAddress : null;
                }
                catch (ConnectException | SocketTimeoutException hostAddress) {
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while checking if package manager dev server is up", e);
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static class DevServer {
        private final Process process;
        private final String hostIPAddress;
        private final StartupLogCompressor logCompressor;

        public DevServer(Process process, String hostIPAddress, StartupLogCompressor logCompressor) {
            this.process = process;
            this.hostIPAddress = hostIPAddress;
            this.logCompressor = logCompressor;
        }

        public Process process() {
            return this.process;
        }

        public String hostIPAddress() {
            return this.hostIPAddress;
        }

        public StartupLogCompressor logCompressor() {
            return this.logCompressor;
        }
    }

    private static class HandleOutput
    implements Runnable {
        private final InputStream is;
        private final Logger.Level logLevel;

        HandleOutput(InputStream is) {
            this(is, Logger.Level.INFO);
        }

        HandleOutput(InputStream is, Logger.Level logLevel) {
            this.is = is;
            this.logLevel = LOG.isEnabled(logLevel) ? logLevel : null;
        }

        @Override
        public void run() {
            block14: {
                try (InputStreamReader isr = new InputStreamReader(this.is);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line = reader.readLine();
                    while (line != null) {
                        if (this.logLevel != null) {
                            LOG.log(this.logLevel, (Object)line);
                        }
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    if (this.logLevel == null) break block14;
                    LOG.log(this.logLevel, (Object)"Failed to handle output", (Throwable)e);
                }
            }
        }
    }
}

