/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.packagemanager.types;

import io.quarkiverse.quinoa.deployment.packagemanager.PackageManagerRunner;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PackageManagerType {
    PNPM("pnpm", "pnpm-lock.yaml", "install --frozen-lockfile"),
    NPM("npm", "package-lock.json", "ci"),
    YARN("yarn", "yarn.lock", "install --frozen-lockfile"),
    YARN_BERRY("yarn", "yarn.lock", "install --immutable");

    public static final String YARN_BERRY_CONFIG_FILE = ".yarnrc.yml";
    private static final Map<String, PackageManagerType> TYPES;
    private final String binary;
    private final String lockFile;
    private final String ciCommand;

    private PackageManagerType(String binary, String lockFile, String ciCommand) {
        this.binary = binary;
        this.lockFile = lockFile;
        this.ciCommand = ciCommand;
    }

    public String getBinary() {
        return this.binary;
    }

    public String getOSBinary() {
        return PackageManagerRunner.isWindows() ? this.binary + ".cmd" : this.binary;
    }

    public String getLockFile() {
        return this.lockFile;
    }

    public String ciCommand() {
        return this.ciCommand;
    }

    public static PackageManagerType resolveConfiguredPackageManagerType(String configuredBinary, PackageManagerType detectedType) {
        PackageManagerType configuredBinaryType = PackageManagerType.resolveBinaryType(configuredBinary);
        if (YARN_BERRY.equals((Object)detectedType) && configuredBinaryType.equals((Object)YARN)) {
            return YARN_BERRY;
        }
        return configuredBinaryType;
    }

    public static PackageManagerType detectPackageManagerType(Path directory) {
        if (Files.isRegularFile(directory.resolve(YARN.getLockFile()), new LinkOption[0])) {
            return PackageManagerType.isYarnBerry(directory) ? YARN_BERRY : YARN;
        }
        if (Files.isRegularFile(directory.resolve(PNPM.getLockFile()), new LinkOption[0])) {
            return PNPM;
        }
        return NPM;
    }

    public static boolean isYarnBerry(Path directory) {
        return Files.isRegularFile(directory.resolve(YARN_BERRY_CONFIG_FILE), new LinkOption[0]);
    }

    public static PackageManagerType resolveBinaryType(String binary) {
        for (Map.Entry<String, PackageManagerType> e : TYPES.entrySet()) {
            if (!binary.contains(e.getKey())) continue;
            return e.getValue();
        }
        throw new UnsupportedOperationException("Unsupported package manager binary: " + binary);
    }

    static {
        TYPES = ((Stream)Arrays.stream(PackageManagerType.values()).sequential()).collect(Collectors.toMap(PackageManagerType::getBinary, Function.identity(), (x, y) -> x, LinkedHashMap::new));
    }
}

