/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa.deployment.config;

import io.quarkiverse.quinoa.QuinoaDevProxyHandlerConfig;
import io.quarkiverse.quinoa.deployment.config.DevServerConfig;
import io.quarkiverse.quinoa.deployment.config.FrameworkConfig;
import io.quarkiverse.quinoa.deployment.config.PackageManagerCommandConfig;
import io.quarkiverse.quinoa.deployment.config.PackageManagerInstallConfig;
import io.quarkus.deployment.util.UriNormalizationUtil;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ConfigMapping(prefix="quarkus.quinoa")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface QuinoaConfig {
    public static final String DEFAULT_BUILD_DIR = "build/";
    public static final String DEFAULT_WEB_UI_ROOT_PATH = "/";
    public static final String DEFAULT_WEB_UI_DIR = "src/main/webui";
    public static final String DEFAULT_INDEX_PAGE = "index.html";

    @WithParentName
    @ConfigDocDefault(value="enabled (disabled in test mode)")
    public Optional<Boolean> enabled();

    @WithDefault(value="false")
    public boolean justBuild();

    @WithDefault(value="/")
    public String uiRootPath();

    @WithDefault(value="src/main/webui")
    public String uiDir();

    @ConfigDocDefault(value="framework detection with fallback to 'build/'")
    public Optional<String> buildDir();

    @ConfigDocDefault(value="auto-detected based on lockfile falling back to 'npm'")
    public Optional<String> packageManager();

    public PackageManagerInstallConfig packageManagerInstall();

    public PackageManagerCommandConfig packageManagerCommand();

    @WithDefault(value="false")
    public boolean runTests();

    @ConfigDocDefault(value="true if environment CI=true")
    public Optional<Boolean> ci();

    @WithDefault(value="false")
    public boolean forceInstall();

    public FrameworkConfig framework();

    @WithDefault(value="false")
    @WithName(value="enable-spa-routing")
    public boolean enableSPARouting();

    @ConfigDocDefault(value="ignore values configured by 'quarkus.resteasy-reactive.path', 'quarkus.rest.path', 'quarkus.resteasy.path' and 'quarkus.http.non-application-root-path'")
    public Optional<List<String>> ignoredPathPrefixes();

    public DevServerConfig devServer();

    @WithDefault(value="false")
    public boolean publish();

    public static List<String> getNormalizedIgnoredPathPrefixes(QuinoaConfig config, NonApplicationRootPathBuildItem nonApplicationRootPath) {
        return config.ignoredPathPrefixes().map(list -> list.stream().map(s -> QuinoaConfig.normalizePath(s, false)).collect(Collectors.toList())).orElseGet(() -> {
            Config allConfig = ConfigProvider.getConfig();
            ArrayList defaultIgnore = new ArrayList();
            String uiRootPath = QuinoaConfig.getNormalizedUiRootPath(config);
            QuinoaConfig.readExternalConfigPath(uiRootPath, allConfig, "quarkus.resteasy.path").ifPresent(defaultIgnore::add);
            QuinoaConfig.readExternalConfigPath(uiRootPath, allConfig, "quarkus.rest.path").ifPresent(defaultIgnore::add);
            QuinoaConfig.readExternalConfigPath(uiRootPath, allConfig, "quarkus.resteasy-reactive.path").ifPresent(defaultIgnore::add);
            QuinoaConfig.convertNonApplicationRootPath(uiRootPath, nonApplicationRootPath).ifPresent(defaultIgnore::add);
            return defaultIgnore;
        });
    }

    public static QuinoaDevProxyHandlerConfig toDevProxyHandlerConfig(QuinoaConfig config, HttpBuildTimeConfig httpBuildTimeConfig, NonApplicationRootPathBuildItem nonApplicationRootPath) {
        Set compressMediaTypes = httpBuildTimeConfig.compressMediaTypes.map(Set::copyOf).orElse(Set.of());
        return new QuinoaDevProxyHandlerConfig(QuinoaConfig.getNormalizedIgnoredPathPrefixes(config, nonApplicationRootPath), config.devServer().indexPage().orElse(DEFAULT_INDEX_PAGE), httpBuildTimeConfig.enableCompression, compressMediaTypes, config.devServer().directForwarding());
    }

    public static String getNormalizedUiRootPath(QuinoaConfig config) {
        return QuinoaConfig.normalizePath(config.uiRootPath(), true);
    }

    private static String normalizePath(String path, boolean trailingSlash) {
        String normalizedPath = UriNormalizationUtil.toURI((String)path, (boolean)trailingSlash).getPath();
        return normalizedPath.startsWith(DEFAULT_WEB_UI_ROOT_PATH) ? normalizedPath : DEFAULT_WEB_UI_ROOT_PATH + normalizedPath;
    }

    private static Optional<String> relativizePath(String rootPath, String leafPath) {
        return Optional.ofNullable(UriNormalizationUtil.relativize((String)rootPath, (String)leafPath)).map(s -> DEFAULT_WEB_UI_ROOT_PATH + s);
    }

    private static Optional<String> readExternalConfigPath(String uiRootPath, Config config, String key) {
        return config.getOptionalValue(key, String.class).map(s -> QuinoaConfig.normalizePath(s, true)).flatMap(s -> QuinoaConfig.relativizePath(uiRootPath, s)).filter(s -> !Objects.equals(s, DEFAULT_WEB_UI_ROOT_PATH)).map(s -> s.endsWith(DEFAULT_WEB_UI_ROOT_PATH) ? s.substring(0, s.length() - 1) : s);
    }

    private static Optional<String> convertNonApplicationRootPath(String uiRootPath, NonApplicationRootPathBuildItem nonApplicationRootPath) {
        return QuinoaConfig.relativizePath(nonApplicationRootPath.getNormalizedHttpRootPath(), nonApplicationRootPath.getNonApplicationRootPath()).flatMap(s -> QuinoaConfig.relativizePath(uiRootPath, s)).filter(s -> !Objects.equals(s, DEFAULT_WEB_UI_ROOT_PATH)).map(s -> s.endsWith(DEFAULT_WEB_UI_ROOT_PATH) ? s.substring(0, s.length() - 1) : s);
    }

    public static boolean isDevServerMode(QuinoaConfig config) {
        return config.devServer().enabled() && config.devServer().port().isPresent();
    }

    public static boolean isEnabled(QuinoaConfig config) {
        return config.enabled().orElse(true);
    }

    public static boolean isEqual(QuinoaConfig q1, QuinoaConfig q2) {
        if (!Objects.equals(q1.enabled(), q2.enabled())) {
            return false;
        }
        if (!Objects.equals(q1.justBuild(), q2.justBuild())) {
            return false;
        }
        if (!Objects.equals(q1.uiRootPath(), q2.uiRootPath())) {
            return false;
        }
        if (!Objects.equals(q1.uiDir(), q2.uiDir())) {
            return false;
        }
        if (!Objects.equals(q1.buildDir(), q2.buildDir())) {
            return false;
        }
        if (!Objects.equals(q1.packageManager(), q2.packageManager())) {
            return false;
        }
        if (!PackageManagerInstallConfig.isEqual(q1.packageManagerInstall(), q2.packageManagerInstall())) {
            return false;
        }
        if (!PackageManagerCommandConfig.isEqual(q1.packageManagerCommand(), q2.packageManagerCommand())) {
            return false;
        }
        if (!Objects.equals(q1.runTests(), q2.runTests())) {
            return false;
        }
        if (!Objects.equals(q1.ci(), q2.ci())) {
            return false;
        }
        if (!Objects.equals(q1.forceInstall(), q2.forceInstall())) {
            return false;
        }
        if (!FrameworkConfig.isEqual(q1.framework(), q2.framework())) {
            return false;
        }
        if (!Objects.equals(q1.enableSPARouting(), q2.enableSPARouting())) {
            return false;
        }
        if (!Objects.equals(q1.ignoredPathPrefixes(), q2.ignoredPathPrefixes())) {
            return false;
        }
        if (!DevServerConfig.isEqual(q1.devServer(), q2.devServer())) {
            return false;
        }
        return Objects.equals(q1.publish(), q2.publish());
    }
}

